/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.recovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jppf.comm.recovery.ReaperEvent;
import org.jppf.comm.recovery.ReaperListener;
import org.jppf.comm.recovery.RecoveryServer;
import org.jppf.comm.recovery.ServerConnection;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reaper {
    private static Logger log = LoggerFactory.getLogger(Reaper.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private int poolSize = 1;
    private long runInterval = 60000L;
    private ExecutorService threadPool = null;
    private RecoveryServer server = null;
    private Timer timer = null;
    private List<ReaperListener> listeners = new ArrayList<ReaperListener>();

    public Reaper(RecoveryServer server, int poolSize, long runInterval) {
        this.server = server;
        this.poolSize = poolSize;
        this.runInterval = runInterval;
        this.threadPool = Executors.newFixedThreadPool(poolSize, new JPPFThreadFactory("Reaper"));
        this.timer = new Timer("Reaper timer");
        this.timer.schedule((TimerTask)new ReaperTask(), 0L, runInterval);
    }

    void newConnection(final ServerConnection connection) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                connection.run();
                Reaper.this.checkConnection(connection);
                if (connection.isOk()) {
                    Reaper.this.server.addConnection(connection);
                }
            }
        };
        new Thread(r).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReaperListener(ReaperListener listener) {
        if (listener == null) {
            return;
        }
        List<ReaperListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReaperListener(ReaperListener listener) {
        if (listener == null) {
            return;
        }
        List<ReaperListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReaperEvent(ServerConnection connection) {
        ReaperEvent event = new ReaperEvent(connection);
        List<ReaperListener> list = this.listeners;
        synchronized (list) {
            for (ReaperListener listener : this.listeners) {
                listener.connectionFailed(event);
            }
        }
    }

    private void checkConnection(ServerConnection connection) {
        if (!connection.isOk()) {
            this.server.removeConnection(connection);
            this.fireReaperEvent(connection);
        } else if (!connection.isInitialized()) {
            this.fireReaperEvent(connection);
            connection.setInitialized(true);
        }
    }

    private class ReaperTask
    extends TimerTask {
        private ReaperTask() {
        }

        @Override
        public void run() {
            ServerConnection[] connections = Reaper.this.server.connections();
            ArrayList futures = new ArrayList(connections.length);
            for (ServerConnection c : connections) {
                futures.add(Reaper.this.threadPool.submit(c));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    if (!debugEnabled) continue;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            for (ServerConnection c : connections) {
                Reaper.this.checkConnection(c);
            }
        }
    }
}

