/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.recovery;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.recovery.Reaper;
import org.jppf.comm.recovery.ServerConnection;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryServer
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(RecoveryServer.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    public static final char DRIVER = 'D';
    public static final char NODE = 'N';
    public static final char CLIENT = 'C';
    private static final ServerConnection[] EMPTY_CONNECTION_ARRAY = new ServerConnection[0];
    private ServerSocket serverSocket = null;
    private List<ServerConnection> connections = new ArrayList<ServerConnection>();
    private AtomicInteger connectionCount = new AtomicInteger(0);
    private int maxRetries = 3;
    private int socketReadTimeout = 6000;
    private int recoveryPort = 22222;
    private Reaper reaper = null;

    public RecoveryServer() {
        this.configure();
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.recoveryPort);
            while (!this.isStopped()) {
                Socket socket = this.serverSocket.accept();
                ServerConnection connection = new ServerConnection(socket, this.maxRetries, this.socketReadTimeout);
                this.reaper.newConnection(connection);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.close();
    }

    private void configure() {
        TypedProperties config = JPPFConfiguration.getProperties();
        this.maxRetries = config.getInt("jppf.recovery.max.retries", 3);
        this.socketReadTimeout = config.getInt("jppf.recovery.read.timeout", 6000);
        this.recoveryPort = config.getInt("jppf.recovery.server.port", 22222);
        int reaperPoolSize = config.getInt("jppf.recovery.reaper.pool.size", Runtime.getRuntime().availableProcessors());
        long reaperRunInterval = config.getLong("jppf.recovery.reaper.run.interval", 60000L);
        this.reaper = new Reaper(this, reaperPoolSize, reaperRunInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setStopped(true);
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            block6: {
                try {
                    this.serverSocket.close();
                }
                catch (Exception e) {
                    if (!debugEnabled) break block6;
                    log.debug("error closing the recovery server socket", (Throwable)e);
                }
            }
            for (ServerConnection c : this.connections) {
                c.close();
            }
            this.connections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection[] connections() {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            return this.connections.toArray(EMPTY_CONNECTION_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(ServerConnection connection) {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(ServerConnection connection) {
        List<ServerConnection> list = this.connections;
        synchronized (list) {
            this.connections.remove(connection);
        }
    }

    public Reaper getReaper() {
        return this.reaper;
    }
}

