/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.recovery;

import java.net.Socket;
import org.jppf.comm.recovery.AbstractRecoveryConnection;
import org.jppf.comm.socket.BootstrapSocketClient;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnection
extends AbstractRecoveryConnection {
    private static Logger log = LoggerFactory.getLogger(ServerConnection.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ServerConnection(Socket socket, int maxRetries, int socketReadTimeout) throws Exception {
        this.ok = true;
        this.initialized = false;
        this.maxRetries = maxRetries;
        this.socketReadTimeout = socketReadTimeout;
        this.socketWrapper = new BootstrapSocketClient(socket);
    }

    @Override
    public synchronized void run() {
        if (!this.isOk()) {
            return;
        }
        if (!this.initialized) {
            this.performHandshake();
        } else {
            this.performCheck();
        }
    }

    private void performHandshake() {
        String response = this.doSendReceive("handshake");
        if (!this.isOk()) {
            return;
        }
        int idx = response.indexOf(59);
        if (idx < 0) {
            this.setOk(false);
            return;
        }
        this.uuid = response.substring(idx + 1);
    }

    private void performCheck() {
        String response = this.doSendReceive("check");
    }

    private String doSendReceive(String message) {
        String response;
        block3: {
            response = null;
            try {
                if (this.socketWrapper == null) {
                    return null;
                }
                this.sendMessage(message);
                response = this.receiveMessage();
            }
            catch (Exception e) {
                this.close();
                if (!debugEnabled) break block3;
                log.debug("error checking " + this, (Throwable)e);
            }
        }
        return response;
    }

    @Override
    public synchronized void close() {
        block3: {
            try {
                if (this.socketWrapper != null) {
                    SocketWrapper tmp = this.socketWrapper;
                    this.socketWrapper = null;
                    this.setOk(false);
                    tmp.close();
                }
            }
            catch (Exception e) {
                if (!debugEnabled) break block3;
                log.debug("error closing " + this, (Throwable)e);
            }
        }
    }

    public String toString() {
        return StringUtils.buildString("ServerConnection[socketWrapper=", this.socketWrapper, ", ok=", this.ok, ", initialized=", this.initialized, ", uuid=", this.uuid, "]");
    }
}

