/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.jppf.JPPFException;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSocketWrapper
implements SocketWrapper {
    private static Logger log = LoggerFactory.getLogger(AbstractSocketWrapper.class);
    protected Socket socket = null;
    protected DataOutputStream dos = null;
    protected DataInputStream dis = null;
    protected String host = null;
    protected int port = -1;
    protected boolean opened = false;
    protected ObjectSerializer serializer = null;

    protected AbstractSocketWrapper() {
    }

    public AbstractSocketWrapper(String host, int port, ObjectSerializer serializer) throws ConnectException, IOException {
        this.host = host;
        this.port = port;
        this.serializer = serializer;
        this.open();
    }

    public AbstractSocketWrapper(Socket socket) throws JPPFException {
        try {
            this.host = socket.getInetAddress().getHostName();
            this.port = socket.getPort();
            this.socket = socket;
            this.initStreams();
            this.opened = true;
        }
        catch (IOException ioe) {
            throw new JPPFException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void sendBytes(JPPFBuffer buf) throws IOException {
        this.checkOpened();
        this.dos.writeInt(buf.getLength());
        this.dos.write(buf.getBuffer(), 0, buf.getLength());
        this.dos.flush();
    }

    @Override
    public void write(byte[] data, int offset, int len) throws Exception {
        this.checkOpened();
        this.dos.write(data, offset, len);
        this.dos.flush();
    }

    @Override
    public void writeInt(int n) throws Exception {
        this.checkOpened();
        this.dos.writeInt(n);
        this.dos.flush();
    }

    @Override
    public void flush() throws IOException {
        this.dos.flush();
    }

    @Override
    public Object receive() throws Exception {
        return this.receive(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JPPFBuffer receiveBytes(int timeout) throws IOException {
        this.checkOpened();
        JPPFBuffer buf = null;
        try {
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            int len = this.dis.readInt();
            byte[] buffer = new byte[len];
            this.read(buffer, 0, len);
            buf = new JPPFBuffer(buffer, len);
        }
        finally {
            if (timeout > 0) {
                this.socket.setSoTimeout(0);
            }
        }
        return buf;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws IOException {
        int count;
        int n;
        this.checkOpened();
        for (count = 0; count < len && (n = this.dis.read(data, count + offset, len - count)) >= 0; count += n) {
        }
        return count;
    }

    @Override
    public int readInt() throws Exception {
        return this.dis.readInt();
    }

    @Override
    public final void open() throws ConnectException, IOException {
        if (!this.opened) {
            if (this.host == null || "".equals(this.host.trim())) {
                throw new ConnectException("You must specify the host name");
            }
            if (this.port <= 0) {
                throw new ConnectException("You must specify the port number");
            }
            this.socket = new Socket();
            InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
            this.socket.setReceiveBufferSize(65536);
            this.socket.setSendBufferSize(65536);
            this.socket.connect(addr);
            this.initStreams();
            this.opened = true;
            if (log.isDebugEnabled()) {
                log.debug("getReceiveBufferSize() = " + this.socket.getReceiveBufferSize());
            }
        }
    }

    protected final void initStreams() throws IOException {
        OutputStream os = this.socket.getOutputStream();
        InputStream is = this.socket.getInputStream();
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this.dos = new DataOutputStream(bos);
        this.dos.flush();
        BufferedInputStream bis = new BufferedInputStream(is);
        this.dis = new DataInputStream(bis);
    }

    @Override
    public void close() throws ConnectException, IOException {
        this.opened = false;
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    protected void checkOpened() throws ConnectException {
        if (!this.opened) {
            throw new ConnectException("Client connection not opened");
        }
    }

    @Override
    public ObjectSerializer getSerializer() {
        return null;
    }

    @Override
    public void setSerializer(ObjectSerializer serializer) {
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public int skip(int n) throws Exception {
        long p;
        if (n < 0) {
            throw new IllegalArgumentException("number of bytes to skip must be >= 0");
        }
        if (n == 0) {
            return 0;
        }
        int count = 0;
        while (count < n && (p = this.dis.skip(n - count)) > 0L) {
            count = (int)((long)count + p);
        }
        return count;
    }
}

