/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jppf.serialization.JPPFObjectStreamFactory;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.JPPFByteArrayOutputStream;
import org.jppf.utils.ObjectSerializer;

public class BootstrapObjectSerializer
implements ObjectSerializer {
    @Override
    public JPPFBuffer serialize(Object o) throws Exception {
        return this.serialize(o, false);
    }

    @Override
    public JPPFBuffer serialize(Object o, boolean noCopy) throws Exception {
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream();
        this.serialize(o, baos);
        byte[] data = noCopy ? baos.getBuf() : baos.toByteArray();
        JPPFBuffer buf = new JPPFBuffer(data, baos.size());
        return buf;
    }

    @Override
    public void serialize(Object o, OutputStream os) throws Exception {
        ObjectOutputStream oos = JPPFObjectStreamFactory.newObjectOutputStream(os);
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    @Override
    public Object deserialize(JPPFBuffer buf) throws Exception {
        return this.deserialize(new ByteArrayInputStream(buf.getBuffer()));
    }

    @Override
    public Object deserialize(byte[] bytes) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes));
    }

    @Override
    public Object deserialize(byte[] bytes, int offset, int length) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes, offset, length));
    }

    @Override
    public Object deserialize(InputStream is) throws Exception {
        Object o = null;
        ObjectInputStream ois = JPPFObjectStreamFactory.newObjectInputStream(is);
        o = ois.readObject();
        ois.close();
        return o;
    }
}

