/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFError;
import org.jppf.comm.socket.AbstractSocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketInitializerImpl
extends AbstractSocketInitializer {
    private static Logger log = LoggerFactory.getLogger(SocketInitializerImpl.class);
    private boolean debugEnabled = log.isDebugEnabled();
    private Date latestAttemptDate = null;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private Timer timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSocket(SocketWrapper socketWrapper) {
        String errMsg = "SocketInitializer.initializeSocket(): Could not reconnect to the remote server";
        String fatalErrMsg = "FATAL: could not initialize the Socket Wrapper!";
        this.socketWrapper = socketWrapper;
        this.lock.lock();
        try {
            block13: {
                long maxTime;
                try {
                    if (this.debugEnabled) {
                        log.debug(this.name + "about to close socket wrapper");
                    }
                    socketWrapper.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                TypedProperties props = JPPFConfiguration.getProperties();
                long delay = 1000L * props.getLong("reconnect.initial.delay", 0L);
                if (delay == 0L) {
                    delay = this.rand.nextInt(10);
                }
                long maxDuration = (maxTime = props.getLong("reconnect.max.time", 60L)) <= 0L ? -1L : 1000L * maxTime;
                long period = 1000L * props.getLong("reconnect.interval", 1L);
                this.latestAttemptDate = maxDuration > 0L ? new Date(System.currentTimeMillis() + maxDuration) : null;
                SocketInitializationTask task = new SocketInitializationTask();
                this.timer = new Timer("Socket initializer timer");
                this.timer.schedule((TimerTask)task, delay, period);
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    if (this.debugEnabled) {
                        log.debug(this.name + e.getMessage(), (Throwable)e);
                    }
                    if (this.closed) break block13;
                    System.err.println(this.name + errMsg);
                    if (this.debugEnabled) {
                        log.debug(this.name + errMsg);
                    }
                    throw new JPPFError(this.name + fatalErrMsg, e);
                }
            }
            this.timer.cancel();
            this.timer.purge();
            if (!this.isSuccessfull() && !this.closed) {
                if (this.debugEnabled) {
                    log.debug(this.name + errMsg);
                }
                System.err.println(this.name + errMsg);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.debugEnabled) {
                log.debug(this.name + "closing socket initializer");
            }
            this.closed = true;
            if (this.timer != null) {
                if (this.debugEnabled) {
                    log.debug(this.name + "timer not null");
                }
                this.timer.cancel();
                this.timer.purge();
            }
        }
    }

    class SocketInitializationTask
    extends TimerTask {
        SocketInitializationTask() {
        }

        @Override
        public void run() {
            block2: {
                ++SocketInitializerImpl.this.attemptCount;
                try {
                    SocketInitializerImpl.this.socketWrapper.open();
                    SocketInitializerImpl.this.successfull = true;
                    this.reset();
                }
                catch (Exception e) {
                    Date now;
                    if (SocketInitializerImpl.this.latestAttemptDate == null || !(now = new Date()).after(SocketInitializerImpl.this.latestAttemptDate)) break block2;
                    SocketInitializerImpl.this.successfull = false;
                    this.reset();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            SocketInitializerImpl.this.lock.lock();
            try {
                this.cancel();
                SocketInitializerImpl.this.condition.signalAll();
            }
            finally {
                SocketInitializerImpl.this.lock.unlock();
            }
        }
    }
}

