/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.data.transform;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jppf.data.transform.JPPFDataTransform;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.MultipleBuffersOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFDataTransformFactory {
    private static Logger log = LoggerFactory.getLogger(JPPFDataTransformFactory.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    private static JPPFDataTransform createInstance() {
        JPPFDataTransform result = null;
        String s = JPPFConfiguration.getProperties().getString("jppf.data.transform.class", null);
        if (s != null) {
            try {
                Class<?> clazz = Class.forName(s);
                result = (JPPFDataTransform)clazz.newInstance();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static JPPFDataTransform getInstance() {
        return JPPFDataTransformFactory.createInstance();
    }

    public static byte[] transform(JPPFDataTransform transform, boolean normal, byte[] data, int offset, int len) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, len);
        MultipleBuffersOutputStream mbos = new MultipleBuffersOutputStream();
        if (normal) {
            transform.wrap(is, mbos);
        } else {
            transform.unwrap(is, mbos);
        }
        return mbos.toByteArray();
    }

    public static byte[] transform(JPPFDataTransform transform, boolean normal, byte[] data) throws Exception {
        return JPPFDataTransformFactory.transform(transform, normal, data, 0, data.length);
    }

    public static byte[] transform(boolean normal, byte[] data, int offset, int len) throws Exception {
        JPPFDataTransform dataTransform = JPPFDataTransformFactory.createInstance();
        return dataTransform == null ? data : JPPFDataTransformFactory.transform(dataTransform, normal, data, offset, len);
    }

    public static byte[] transform(boolean normal, byte[] data) throws Exception {
        JPPFDataTransform dataTransform = JPPFDataTransformFactory.createInstance();
        return dataTransform == null ? data : JPPFDataTransformFactory.transform(dataTransform, normal, data, 0, data.length);
    }

    public static byte[] transform(boolean normal, InputStream is) throws Exception {
        JPPFDataTransform dataTransform = JPPFDataTransformFactory.createInstance();
        if (dataTransform == null) {
            return FileUtils.getInputStreamAsByte(is);
        }
        MultipleBuffersOutputStream mbos = new MultipleBuffersOutputStream();
        if (normal) {
            dataTransform.wrap(is, mbos);
        } else {
            dataTransform.unwrap(is, mbos);
        }
        return mbos.toByteArray();
    }
}

