/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.logging.jdk;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jppf.utils.StringUtils;

public class JPPFLogFormatter
extends Formatter {
    private final SimpleDateFormat sdf = new SimpleDateFormat("[yyyy/MM/dd hh:mm:ss.SSS]");

    @Override
    public String format(LogRecord record) {
        Object[] params;
        StringBuilder sb = new StringBuilder();
        sb.append(this.sdf.format(new Date(record.getMillis())));
        sb.append("[").append(StringUtils.padRight(record.getLevel().getName(), ' ', 7)).append("]");
        sb.append("[");
        String s = record.getSourceClassName();
        String shortName = this.getShortName(s);
        StackTraceElement[] elts = new Throwable().getStackTrace();
        StackTraceElement elt = null;
        for (int i = 0; i < elts.length; ++i) {
            if (!this.getShortName(elts[i].getClassName()).equals(shortName)) continue;
            elt = elts[i];
            break;
        }
        if (elt != null) {
            sb.append(elt.getClassName());
            if (elt.getMethodName() != null) {
                sb.append(".").append(elt.getMethodName());
            }
            sb.append("(");
            if (elt.getLineNumber() >= 0) {
                sb.append(elt.getLineNumber());
            }
            sb.append(")");
        } else {
            if (s != null) {
                sb.append(s);
            }
            if ((s = record.getSourceMethodName()) != null) {
                sb.append(".").append(s).append("()");
            }
        }
        sb.append("]");
        sb.append(": ");
        s = record.getMessage();
        if (s != null) {
            sb.append(s);
        }
        if ((params = record.getParameters()) != null) {
            for (Object o : params) {
                sb.append("|").append(o);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getShortName(String fqn) {
        int idx = fqn.lastIndexOf(46);
        return idx >= 0 ? fqn.substring(idx + 1) : fqn;
    }
}

