/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.logging.jdk;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.jppf.logging.jdk.JPPFLogFormatter;
import org.jppf.logging.jmx.JmxMessageNotifier;

public class JmxHandler
extends Handler {
    private JmxMessageNotifier notifier = null;
    private String mbeanName = null;

    private void init() {
        LogManager lm = LogManager.getLogManager();
        this.mbeanName = lm.getProperty(this.getClass().getName() + ".mbeanName");
        this.notifier = new JmxMessageNotifier(this.mbeanName);
    }

    @Override
    public void publish(LogRecord record) {
        Formatter f;
        if (this.notifier == null) {
            this.init();
        }
        if ((f = this.getFormatter()) == null) {
            f = new JPPFLogFormatter();
        }
        String s = f.format(record);
        this.notifier.sendMessage(s);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

