/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.logging.log4j;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.jppf.logging.jmx.JmxMessageNotifier;

public class JmxAppender
extends AppenderSkeleton {
    private static Layout DEFAULT_LAYOUT = new SimpleLayout();
    private static String LINE_SEP = System.getProperty("line.separator");
    private JmxMessageNotifier notifier = null;
    private String mbeanName = null;

    private void init() {
        this.notifier = new JmxMessageNotifier(this.mbeanName);
    }

    protected void append(LoggingEvent event) {
        String[] strs;
        Layout layout;
        if (this.notifier == null) {
            this.init();
        }
        if ((layout = this.getLayout()) == null) {
            layout = DEFAULT_LAYOUT;
        }
        StringBuilder sb = new StringBuilder(layout.format(event));
        if (layout.ignoresThrowable() && (strs = event.getThrowableStrRep()) != null) {
            for (String s : strs) {
                sb.append(s).append(LINE_SEP);
            }
        }
        this.notifier.sendMessage(sb.toString());
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    public void setMbeanName(String mbeanName) {
        this.mbeanName = mbeanName;
    }
}

