/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConnectionWrapper
extends ThreadSynchronization {
    private static Logger log = LoggerFactory.getLogger(JMXConnectionWrapper.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private JMXServiceURL url = null;
    private JMXConnector jmxc = null;
    private AtomicReference<MBeanServerConnection> mbeanConnection = new AtomicReference<Object>(null);
    private String host = null;
    private int port = 0;
    private AtomicReference<JMXConnectionThread> connectionThread = new AtomicReference<Object>(null);
    private String idString = null;
    private AtomicBoolean connected = new AtomicBoolean(false);
    protected boolean local = false;

    public JMXConnectionWrapper() {
        this.local = true;
    }

    public JMXConnectionWrapper(String host, int port, String rmiSuffix) {
        this.host = host;
        this.port = port;
        try {
            String s = NetworkUtils.getHostName(host);
            this.idString = (s == null ? "_" : s) + ":" + port;
            this.url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + host + ":" + port + rmiSuffix);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.local = false;
    }

    public void connect() {
        if (this.local) {
            this.mbeanConnection.set(ManagementFactory.getPlatformMBeanServer());
            this.setConnectedStatus(true);
        } else {
            this.connectionThread.set(new JMXConnectionThread());
            Thread t = new Thread((Runnable)this.connectionThread.get(), "JMX connection " + this.getId());
            t.setDaemon(true);
            t.start();
        }
    }

    public void connectAndWait(long timeout) {
        if (this.isConnected()) {
            return;
        }
        this.connect();
        if (this.isConnected()) {
            return;
        }
        this.goToSleep(timeout);
    }

    private synchronized void performConnection() throws Exception {
        this.connected.set(false);
        HashMap env = new HashMap();
        this.jmxc = JMXConnectorFactory.connect(this.url, env);
        this.mbeanConnection.set(this.jmxc.getMBeanServerConnection());
        this.setConnectedStatus(true);
        if (debugEnabled) {
            log.debug(this.getId() + " JMX connection successfully established");
        }
    }

    public void close() throws Exception {
        if (this.connectionThread.get() != null) {
            this.connectionThread.get().close();
        }
        if (this.jmxc != null) {
            this.jmxc.close();
        }
    }

    public synchronized Object invoke(String name, String methodName, Object[] params, String[] signature) throws Exception {
        Object result;
        block8: {
            if (this.connectionThread.get() != null && this.connectionThread.get().isConnecting()) {
                return null;
            }
            result = null;
            try {
                ObjectName mbeanName = new ObjectName(name);
                result = this.getMbeanConnection().invoke(mbeanName, methodName, params, signature);
            }
            catch (IOException e) {
                block7: {
                    this.setConnectedStatus(false);
                    try {
                        if (this.jmxc != null) {
                            this.jmxc.close();
                        }
                    }
                    catch (Exception e2) {
                        if (!debugEnabled) break block7;
                        log.debug(e2.getMessage(), (Throwable)e2);
                    }
                }
                if (!this.connectionThread.get().isConnecting()) {
                    this.connectionThread.get().resume();
                }
                if (!debugEnabled) break block8;
                log.debug(this.getId() + " : error while invoking the JMX connection", (Throwable)e);
            }
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.idString;
    }

    public MBeanServerConnection getMbeanConnection() {
        return this.mbeanConnection.get();
    }

    protected void setConnectedStatus(boolean status) {
        this.connected.set(status);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public <T> T getProxy(String name, Class<T> inf) throws Exception {
        return this.getProxy(new ObjectName(name), inf);
    }

    public <T> T getProxy(ObjectName objectName, Class<T> inf) throws Exception {
        if (!this.isConnected()) {
            this.connectAndWait(5000L);
        }
        MBeanServerConnection mbsc = this.getMbeanConnection();
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, objectName, inf, true);
    }

    public class JMXConnectionThread
    extends ThreadSynchronization
    implements Runnable {
        private boolean suspended = false;
        private boolean connecting = true;

        @Override
        public void run() {
            while (!this.isStopped()) {
                if (this.isSuspended()) {
                    if (debugEnabled) {
                        log.debug(JMXConnectionWrapper.this.getId() + " about to go to sleep");
                    }
                    this.goToSleep();
                    continue;
                }
                if (!this.connecting) continue;
                try {
                    if (debugEnabled) {
                        log.debug(JMXConnectionWrapper.this.getId() + " about to perform RMI connection attempts");
                    }
                    JMXConnectionWrapper.this.performConnection();
                    if (debugEnabled) {
                        log.debug(JMXConnectionWrapper.this.getId() + " about to suspend RMI connection attempts");
                    }
                    this.suspend();
                    this.wakeUp();
                    JMXConnectionWrapper.this.wakeUp();
                }
                catch (Exception ignored) {
                    if (debugEnabled) {
                        log.debug(JMXConnectionWrapper.this.getId() + " JMX URL = " + JMXConnectionWrapper.this.url, (Throwable)ignored);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        public synchronized void suspend() {
            if (debugEnabled) {
                log.debug(JMXConnectionWrapper.this.getId() + " suspending RMI connection attempts");
            }
            this.setConnecting(false);
            this.setSuspended(true);
        }

        public synchronized void resume() {
            if (debugEnabled) {
                log.debug(JMXConnectionWrapper.this.getId() + " resuming RMI connection attempts");
            }
            this.setConnecting(true);
            this.setSuspended(false);
            this.wakeUp();
        }

        public synchronized void close() {
            this.setConnecting(false);
            this.setStopped(true);
            this.wakeUp();
        }

        public synchronized boolean isConnecting() {
            return this.connecting;
        }

        public synchronized void setConnecting(boolean connecting) {
            this.connecting = connecting;
        }

        public synchronized boolean isSuspended() {
            return this.suspended;
        }

        public synchronized void setSuspended(boolean suspended) {
            this.suspended = suspended;
        }
    }
}

