/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.NetworkUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXServerImpl {
    private static Logger log = LoggerFactory.getLogger(JMXServerImpl.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static Registry registry = null;
    private MBeanServer server = null;
    private JMXConnectorServer connectorServer = null;
    private boolean stopped = true;
    private String id = new JPPFUuid(JPPFUuid.ALPHA_NUM, 24).toString();
    private String namespaceSuffix = null;

    public JMXServerImpl(String namespaceSuffix) {
        this.namespaceSuffix = namespaceSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClassLoader cl) throws Exception {
        if (debugEnabled) {
            log.debug("starting remote connector server");
        }
        ClassLoader tmp = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.server = ManagementFactory.getPlatformMBeanServer();
            TypedProperties props = JPPFConfiguration.getProperties();
            String host = NetworkUtils.getManagementHost();
            int port = JMXServerImpl.locateOrCreateRegistry();
            int rmiPort = props.getInt("jppf.management.rmi.port", 12198);
            boolean found = false;
            JMXServiceURL url = null;
            while (!found) {
                try {
                    InetAddress addr = InetAddress.getByName(host);
                    url = new JMXServiceURL("service:jmx:rmi://" + host + ":" + rmiPort + "/jndi/rmi://localhost:" + port + this.namespaceSuffix);
                    HashMap<String, ClassLoader> env = new HashMap<String, ClassLoader>();
                    env.put("jmx.remote.default.class.loader", cl);
                    env.put("jmx.remote.protocol.provider.class.loader", cl);
                    this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.server);
                    this.connectorServer.start();
                    found = true;
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof BindException) {
                        if (rmiPort >= 65530) {
                            rmiPort = 1024;
                        }
                        ++rmiPort;
                        continue;
                    }
                    throw e;
                }
            }
            props.setProperty("jppf.management.rmi.port", "" + rmiPort);
            if (debugEnabled) {
                log.debug("starting connector server with RMI registry port = " + port + " and RMI server port = " + rmiPort);
            }
            this.stopped = false;
            if (debugEnabled) {
                log.debug("JMXConnectorServer started at URL " + url);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tmp);
        }
    }

    public void stop() throws Exception {
        this.stopped = true;
        this.connectorServer.stop();
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private static synchronized int locateOrCreateRegistry() throws Exception {
        TypedProperties props = JPPFConfiguration.getProperties();
        int port = props.getInt("jppf.management.port", 11198);
        if (registry != null) {
            return port;
        }
        if (debugEnabled) {
            log.debug("starting RMI registry on port " + port);
        }
        boolean found = false;
        while (!found) {
            try {
                registry = LocateRegistry.createRegistry(port);
                found = true;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof BindException) {
                    if (port >= 65530) {
                        port = 1024;
                    }
                    ++port;
                    continue;
                }
                throw e;
            }
        }
        props.setProperty("jppf.management.port", "" + port);
        return port;
    }

    public String getId() {
        return this.id;
    }
}

