/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.Serializable;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.utils.NetworkUtils;

public class JPPFManagementInfo
implements Serializable,
Comparable<JPPFManagementInfo> {
    private static final long serialVersionUID = 1L;
    public static final int DRIVER = 0;
    public static final int NODE = 1;
    private String host = null;
    private int port = 11198;
    private String id = null;
    private int type = 1;
    private transient JPPFSystemInformation systemInfo = null;

    public JPPFManagementInfo(String host, int port, String id) {
        this(host, port, id, 1);
    }

    public JPPFManagementInfo(String host, int port, String id, int type) {
        this.host = NetworkUtils.getHostName(host);
        this.port = port;
        this.id = id;
        this.type = type;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPPFManagementInfo other = (JPPFManagementInfo)obj;
        if (other.id == null) {
            return this.id == null;
        }
        return this.id == null ? false : this.id.equals(other.id);
    }

    @Override
    public int compareTo(JPPFManagementInfo o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        int n = -1 * this.host.compareTo(o.getHost());
        if (n != 0) {
            return n;
        }
        return this.port - o.getPort();
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public synchronized JPPFSystemInformation getSystemInfo() {
        return this.systemInfo;
    }

    public synchronized void setSystemInfo(JPPFSystemInformation systemInfo) {
        this.systemInfo = systemInfo;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }
}

