/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jppf.node.event.NodeEventType;

public class JPPFNodeState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Serializable taskEvent = "";
    private String connectionStatus = NodeEventType.UNKNOWN.toString();
    private String executionStatus = NodeEventType.UNKNOWN.toString();
    private int nbTasksExecuted = 0;
    private long cpuTime = 0L;
    private transient Map<String, Integer> taskIdMap = new HashMap<String, Integer>();
    private Set<String> taskIdSet = new HashSet<String>();
    private int threadPoolSize = -1;
    private int threadPriority = -1;

    public synchronized Serializable getTaskNotification() {
        return this.taskEvent;
    }

    public synchronized void setTaskEvent(Serializable taskEvent) {
        this.taskEvent = taskEvent;
    }

    public synchronized int getNbTasksExecuted() {
        return this.nbTasksExecuted;
    }

    public synchronized void setNbTasksExecuted(int nbTasksExecuted) {
        this.nbTasksExecuted = nbTasksExecuted;
    }

    public synchronized String getConnectionStatus() {
        return this.connectionStatus;
    }

    public synchronized void setConnectionStatus(String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public synchronized String getExecutionStatus() {
        return this.executionStatus;
    }

    public synchronized void setExecutionStatus(String executionStatus) {
        this.executionStatus = executionStatus;
    }

    public synchronized void taskStarted(String id) {
        if (id == null) {
            return;
        }
        Integer n = this.taskIdMap.get(id);
        n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
        if (!this.taskIdSet.contains(id)) {
            this.taskIdSet.add(id);
        }
        this.taskIdMap.put(id, n);
    }

    public synchronized void taskEnded(String id) {
        if (id == null) {
            return;
        }
        Integer n = this.taskIdMap.get(id);
        if (n == null) {
            return;
        }
        if ((n = Integer.valueOf(n - 1)) <= 0) {
            this.taskIdMap.remove(id);
            this.taskIdSet.remove(id);
        } else {
            this.taskIdMap.put(id, n);
        }
    }

    public synchronized Set<String> getAllTaskIds() {
        return Collections.unmodifiableSet(this.taskIdSet);
    }

    public synchronized void setTaskIdSet(Set<String> taskIdSet) {
        this.taskIdSet = taskIdSet;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public synchronized long getCpuTime() {
        return this.cpuTime;
    }

    public synchronized void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public JPPFNodeState copy() {
        JPPFNodeState s = new JPPFNodeState();
        s.setNbTasksExecuted(this.getNbTasksExecuted());
        s.setConnectionStatus(this.getConnectionStatus());
        s.setExecutionStatus(this.getExecutionStatus());
        s.setTaskEvent(this.getTaskNotification());
        s.setTaskIdSet(this.getAllTaskIds());
        s.setThreadPoolSize(this.getThreadPoolSize());
        s.setThreadPriority(this.getThreadPriority());
        s.setCpuTime(this.getCpuTime());
        return s;
    }
}

