/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management;

import java.io.Serializable;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.Pair;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;

public class JPPFSystemInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TypedProperties system = null;
    private TypedProperties runtime = null;
    private TypedProperties env = null;
    private TypedProperties jppf = null;
    private TypedProperties network = null;
    private TypedProperties storage = null;

    public TypedProperties getSystem() {
        return this.system;
    }

    public TypedProperties getRuntime() {
        return this.runtime;
    }

    public TypedProperties getEnv() {
        return this.env;
    }

    public TypedProperties getNetwork() {
        return this.network;
    }

    public TypedProperties getJppf() {
        return this.jppf;
    }

    public TypedProperties getStorage() {
        return this.storage;
    }

    public void populate() {
        this.system = SystemUtils.getSystemProperties();
        this.runtime = SystemUtils.getRuntimeInformation();
        this.env = SystemUtils.getEnvironment();
        this.jppf = JPPFConfiguration.getProperties();
        this.network = SystemUtils.getNetwork();
        this.storage = SystemUtils.getStorageInformation();
    }

    private HostIP[] parseIPV4Addresses() {
        String s = this.getNetwork().getString("ipv4.adresses");
        if (s == null || "".equals(s.trim())) {
            return null;
        }
        return this.parseAddresses(s);
    }

    private HostIP[] parseIPV6Addresses() {
        String s = this.getNetwork().getString("ipv6.adresses");
        if (s == null || "".equals(s.trim())) {
            return null;
        }
        return this.parseAddresses(s);
    }

    private HostIP[] parseAddresses(String addresses) {
        String[] pairs = addresses.split("\\s");
        if (pairs == null || pairs.length <= 0) {
            return null;
        }
        HostIP[] result = new HostIP[pairs.length];
        int count = 0;
        for (String pair : pairs) {
            String[] comps = pair.split("|");
            if (comps[0] != null && "".equals(comps[0].trim())) {
                comps[0] = null;
            }
            result[count++] = new HostIP(comps[0], comps[1]);
        }
        return result;
    }

    public static class HostIP
    extends Pair<String, String> {
        public HostIP(String first, String second) {
            super(first, second);
        }

        public String hostName() {
            return (String)this.first();
        }

        public String ipAddress() {
            return (String)this.second();
        }
    }
}

