/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.net;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jppf.net.PatternConfiguration;
import org.jppf.utils.Range;
import org.jppf.utils.StringUtils;

public abstract class AbstractIPAddressPattern {
    List<Range<Integer>> ranges = new ArrayList<Range<Integer>>();
    PatternConfiguration config = null;

    public AbstractIPAddressPattern(String source, PatternConfiguration config) throws IllegalArgumentException {
        this.config = config;
        this.convertSource(source);
    }

    protected void convertSource(String source) throws IllegalArgumentException {
        if (source == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        String src = this.preProcess(source);
        src = PatternConfiguration.SPACES_PATTERN.matcher(src).replaceAll("");
        String[] rangeArray = this.config.compSeparatorPattern.split(src = this.postProcess(src));
        if (rangeArray == null || rangeArray.length == 0) {
            throw new IllegalArgumentException("invalid empty pattern");
        }
        if (rangeArray.length > this.config.nbComponents) {
            throw new IllegalArgumentException("pattern describes more than " + this.config.nbComponents + " components : \"" + source + "\"");
        }
        try {
            for (String s : rangeArray) {
                this.ranges.add(this.parseRangePattern(s));
            }
            if (rangeArray.length < this.config.nbComponents) {
                for (int i = rangeArray.length; i < this.config.nbComponents; ++i) {
                    this.ranges.add(this.config.fullRange);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(StringUtils.buildString("error in pattern \"", source, "\" : ", e.getMessage()));
        }
    }

    protected String preProcess(String source) {
        return source;
    }

    protected String postProcess(String source) {
        return source;
    }

    public boolean matches(InetAddress ip) {
        return this.matches(StringUtils.toIntArray(ip));
    }

    public boolean matches(int[] values) {
        try {
            if (values == null || values.length != this.ranges.size()) {
                return false;
            }
            for (int i = 0; i < values.length; ++i) {
                if (this.ranges.get(i).isValueInRange(values[i])) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Range<Integer> parseRangePattern(String src) throws IllegalArgumentException {
        if (src == null || "".equals(src)) {
            return this.config.fullRange;
        }
        if (src.indexOf(45) < 0) {
            return new Range<Integer>(this.parseValue(src));
        }
        String[] vals = PatternConfiguration.MINUS_PATTERN.split(src);
        if (vals == null || vals.length == 0) {
            return this.config.fullRange;
        }
        if (vals.length > 2) {
            throw new IllegalArgumentException(StringUtils.buildString("invalid range pattern (pattern: ", src, ")"));
        }
        int lower = 0;
        int upper = 0;
        if (vals.length == 1) {
            if (src.startsWith("-")) {
                lower = this.config.minValue;
                upper = this.parseValue(vals[0]);
            } else {
                lower = this.parseValue(vals[0]);
                upper = this.config.maxValue;
            }
        } else {
            lower = "".equals(vals[0]) ? this.config.minValue : this.parseValue(vals[0]);
            int n = upper = "".equals(vals[1]) ? this.config.maxValue : this.parseValue(vals[1]);
        }
        if (upper < lower) {
            throw new IllegalArgumentException(StringUtils.buildString("lower bound must be <= upper bound (pattern: ", src, ")"));
        }
        return new Range<Integer>(lower, upper);
    }

    private int parseValue(String src) throws IllegalArgumentException {
        try {
            int value = Integer.decode(this.config.valuePrefix + src.toLowerCase());
            if (value < this.config.minValue || value > this.config.maxValue) {
                throw new IllegalArgumentException(StringUtils.buildString("value must be in [", this.config.minValue, " ... ", this.config.maxValue, "] range (value: ", src, ")"));
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(StringUtils.buildString("invalid value format (value: ", src, ")"));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (i > 0) {
                sb.append(this.config.compSeparator);
            }
            sb.append(this.ranges.get(i));
        }
        return sb.toString();
    }
}

