/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketInitializerImpl;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.node.MonitoredNode;
import org.jppf.node.event.NodeEvent;
import org.jppf.node.event.NodeEventType;
import org.jppf.node.event.NodeListener;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.SerializationHelper;
import org.jppf.utils.ThreadSynchronization;

public abstract class AbstractMonitoredNode
extends ThreadSynchronization
implements MonitoredNode,
Runnable {
    protected SerializationHelper helper = null;
    protected ObjectSerializer serializer = null;
    protected SocketWrapper socketClient = null;
    protected SocketInitializer socketInitializer = new SocketInitializerImpl();
    protected List<NodeListener> listeners = new ArrayList<NodeListener>();
    protected boolean notifying = false;
    private int taskCount = 0;
    protected String uuid = null;
    protected AtomicInteger executingCount = new AtomicInteger(0);

    @Override
    public void addNodeListener(NodeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
        this.notifying = true;
    }

    @Override
    public void removeNodeListener(NodeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.size() <= 0) {
            this.notifying = false;
        }
    }

    @Override
    public synchronized void fireNodeEvent(NodeEventType eventType) {
        NodeEvent event = new NodeEvent(eventType);
        for (NodeListener listener : this.listeners) {
            listener.eventOccurred(event);
        }
    }

    @Override
    public synchronized void fireNodeEvent(int nbTasks) {
        NodeEvent event = new NodeEvent(nbTasks);
        for (NodeListener listener : this.listeners) {
            listener.eventOccurred(event);
        }
    }

    @Override
    public SocketWrapper getSocketWrapper() {
        return this.socketClient;
    }

    @Override
    public void setSocketWrapper(SocketWrapper wrapper) {
        this.socketClient = wrapper;
    }

    public boolean isNotifying() {
        return this.notifying;
    }

    @Override
    public abstract void stopNode(boolean var1);

    public synchronized int getTaskCount() {
        return this.taskCount;
    }

    public synchronized void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    public SerializationHelper getHelper() {
        return this.helper;
    }

    public void decrementExecutingCount() {
        if (this.executingCount.decrementAndGet() == 0) {
            this.fireNodeEvent(NodeEventType.END_EXEC);
        }
        this.fireNodeEvent(NodeEventType.TASK_EXECUTED);
    }

    public void incrementExecutingCount() {
        if (this.executingCount.incrementAndGet() == 1) {
            this.fireNodeEvent(NodeEventType.START_EXEC);
        }
    }
}

