/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node;

import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jppf.JPPFException;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.JPPFNodeReloadNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.logging.jmx.JmxMessageNotifier;
import org.jppf.node.MonitoredNode;
import org.jppf.process.LauncherListener;
import org.jppf.security.JPPFPolicy;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.SimpleObjectLock;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRunner {
    private static Logger log = LoggerFactory.getLogger(NodeRunner.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static AbstractJPPFClassLoader classLoader = null;
    private static boolean securityManagerSet = false;
    private static SocketWrapper nodeSocket = null;
    private static Hashtable<Object, Object> persistentData = new Hashtable();
    private static ExecutorService executor = Executors.newFixedThreadPool(1);
    private static final ShutdownOrRestart SHUTDOWN_TASK = new ShutdownOrRestart(false);
    private static final ShutdownOrRestart RESTART_TASK = new ShutdownOrRestart(true);
    private static MonitoredNode node = null;
    private static SimpleObjectLock serviceLock = new SimpleObjectLock();
    private static String uuid = new JPPFUuid().toString();
    private static IPFilter ipFilter = new IPFilter(JPPFConfiguration.getProperties());

    /*
     * Unable to fully structure code
     */
    public static void main(String ... args) {
        NodeRunner.node = null;
        try {
            new JmxMessageNotifier();
            if (NodeRunner.debugEnabled) {
                NodeRunner.log.debug("launching the JPPF node");
            }
            if (args == null || args.length <= 0) {
                throw new JPPFException("The node should be run with an argument representing a valid TCP port or 'noLauncher'");
            }
            if (!"noLauncher".equals(args[0])) {
                port = Integer.parseInt(args[0]);
                new LauncherListener(port).start();
            }
        }
        catch (Exception e) {
            NodeRunner.log.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        try {
            NodeRunner.log.info("starting node");
            VersionUtils.getBuildNumber();
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        NodeRunner.node = NodeRunner.createNode();
                        NodeRunner.node.run();
                    }
                }
                catch (JPPFNodeReloadNotification notif) {
                    if (NodeRunner.debugEnabled) {
                        NodeRunner.log.debug("received reload notification");
                    }
                    NodeRunner.nodeSocket = NodeRunner.node.getSocketWrapper();
                    System.out.println(notif.getMessage());
                    System.out.println("Reloading this node");
                    NodeRunner.classLoader.close();
                    NodeRunner.classLoader = null;
                    NodeRunner.node.stopNode(false);
                    NodeRunner.unsetSecurity();
                }
                catch (JPPFNodeReconnectionNotification e) {
                    if (NodeRunner.debugEnabled) {
                        NodeRunner.log.debug("received reconnection notification");
                    }
                    if (NodeRunner.classLoader != null) {
                        NodeRunner.classLoader.close();
                    }
                    NodeRunner.classLoader = null;
                    if (NodeRunner.node != null) {
                        NodeRunner.node.stopNode(true);
                    }
                    NodeRunner.unsetSecurity();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ** GOTO lbl-1000
    }

    public static void start(String ... args) {
        NodeRunner.main(args);
        serviceLock.goToSleep();
    }

    public static void stop(String ... args) {
        serviceLock.wakeUp();
        System.exit(0);
    }

    public static MonitoredNode createNode() throws Exception {
        if (JPPFConfiguration.getProperties().getBoolean("jppf.discovery.enabled", true)) {
            NodeRunner.discoverDriver();
        }
        NodeRunner.setSecurity();
        String className = "org.jppf.server.node.remote.JPPFRemoteNode";
        Class<?> clazz = NodeRunner.getJPPFClassLoader().loadClass(className);
        MonitoredNode node = (MonitoredNode)clazz.newInstance();
        if (debugEnabled) {
            log.debug("Created new node instance: " + node);
        }
        node.setSocketWrapper(nodeSocket);
        return node;
    }

    public static void discoverDriver() {
        JPPFMulticastReceiver receiver = new JPPFMulticastReceiver(ipFilter);
        JPPFConnectionInformation info = receiver.receive();
        receiver.setStopped(true);
        if (info == null) {
            if (debugEnabled) {
                log.debug("Could not auto-discover the driver connection information");
            }
            return;
        }
        if (debugEnabled) {
            log.debug("Discovered driver: " + info);
        }
        TypedProperties config = JPPFConfiguration.getProperties();
        config.setProperty("jppf.server.host", info.host);
        config.setProperty("class.server.port", StringUtils.buildString(info.classServerPorts));
        config.setProperty("node.server.port", StringUtils.buildString(info.nodeServerPorts));
        if (info.managementHost != null) {
            config.setProperty("jppf.management.host", info.managementHost);
        }
        if (info.recoveryPort >= 0) {
            config.setProperty("jppf.recovery.server.port", "" + info.recoveryPort);
            config.setProperty("jppf.recovery.enabled", "true");
        } else {
            config.setProperty("jppf.recovery.enabled", "false");
        }
    }

    public static void setSecurity() throws Exception {
        TypedProperties props;
        String s;
        if (!securityManagerSet && (s = (props = JPPFConfiguration.getProperties()).getString("jppf.policy.file")) != null) {
            if (debugEnabled) {
                log.debug("setting security");
            }
            String rmiHostName = props.getString("jppf.management.host", "localhost");
            System.setProperty("java.rmi.server.hostname", rmiHostName);
            Policy.setPolicy(new JPPFPolicy(NodeRunner.getJPPFClassLoader()));
            System.setSecurityManager(new SecurityManager());
            securityManagerSet = true;
        }
    }

    public static void unsetSecurity() {
        if (securityManagerSet) {
            if (debugEnabled) {
                log.debug("un-setting security");
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setSecurityManager(null);
                    return null;
                }
            });
            securityManagerSet = false;
        }
    }

    public static AbstractJPPFClassLoader getJPPFClassLoader() {
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<JPPFClassLoader>(){

                @Override
                public JPPFClassLoader run() {
                    JPPFClassLoader cl = new JPPFClassLoader(NodeRunner.class.getClassLoader());
                    return cl;
                }
            });
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return classLoader;
    }

    public static synchronized void setPersistentData(Object key, Object value) {
        persistentData.put(key, value);
    }

    public static synchronized Object getPersistentData(Object key) {
        return persistentData.get(key);
    }

    public static synchronized Object removePersistentData(Object key) {
        return persistentData.remove(key);
    }

    public static MonitoredNode getNode() {
        return node;
    }

    public static void shutdown(MonitoredNode node, boolean restart) {
        executor.submit(restart ? RESTART_TASK : SHUTDOWN_TASK);
    }

    public static String getUuid() {
        return uuid;
    }

    public static class ShutdownOrRestart
    implements Runnable {
        private boolean restart = false;

        public ShutdownOrRestart(boolean restart) {
            this.restart = restart;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.exit(ShutdownOrRestart.this.restart ? 2 : 0);
                    return null;
                }
            });
        }
    }
}

