/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.idle;

import java.util.Timer;
import java.util.TimerTask;
import org.jppf.JPPFException;
import org.jppf.node.idle.IdleDetectionTask;
import org.jppf.node.idle.IdleState;
import org.jppf.node.idle.IdleStateEvent;
import org.jppf.node.idle.IdleStateListener;
import org.jppf.node.idle.IdleTimeDetectorFactory;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleDetector
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(IdleDetector.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Timer timer = null;
    private IdleTimeDetectorFactory factory = null;
    private IdleDetectionTask task = null;
    private long idleTimeout = -1L;
    private long pollInterval = -1L;
    private IdleStateListener listener = null;

    public IdleDetector(IdleStateListener listener) {
        this.listener = listener;
    }

    private void init() throws Exception {
        TypedProperties config = JPPFConfiguration.getProperties();
        String factoryName = config.getString("jppf.idle.detector.factory", null);
        this.idleTimeout = config.getLong("jppf.idle.timeout", 300000L);
        this.pollInterval = config.getLong("jppf.idle.poll.interval", 1000L);
        if (factoryName == null) {
            throw new JPPFException("Idle detector factory name not specified");
        }
        Class<?> c = Class.forName(factoryName);
        this.factory = (IdleTimeDetectorFactory)c.newInstance();
    }

    @Override
    public void run() {
        try {
            if (this.factory == null) {
                this.init();
            }
            IdleStateListener tmp = new IdleStateListener(){

                @Override
                public void idleStateChanged(IdleStateEvent event) {
                    System.out.println("System is now " + (Object)((Object)event.getState()));
                }
            };
            this.task = new IdleDetectionTask(this.factory, this.idleTimeout, this.listener, tmp);
            this.timer = new Timer(IdleDetector.class.getSimpleName() + " Timer");
            this.timer.schedule((TimerTask)this.task, 0L, this.pollInterval);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            TypedProperties config = JPPFConfiguration.getProperties();
            String factoryName = config.getProperty("jppf.idle.detector.factory", null);
            if (factoryName == null) {
                throw new JPPFException("Idle detector factory name not specified");
            }
            Class<?> c = Class.forName(factoryName);
            IdleTimeDetectorFactory factory = (IdleTimeDetectorFactory)c.newInstance();
            Timer timer = new Timer(IdleDetector.class.getSimpleName() + " Timer");
            IdleDetectionTask task = new IdleDetectionTask(factory, 6000L, new IdleStateListener[0]);
            task.addIdleStateListener(new IdleStateListener(){

                @Override
                public void idleStateChanged(IdleStateEvent event) {
                    if (IdleState.IDLE.equals((Object)event.getState())) {
                        System.out.println("System is now idle !");
                    } else {
                        System.out.println("System is now busy");
                    }
                }
            });
            timer.schedule((TimerTask)task, 0L, 200L);
            Thread.sleep(60000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

