/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.policy;

import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.policy.ExecutionPolicy;

public class Equal
extends ExecutionPolicy {
    private String propertyName = null;
    private Number numberValue = null;
    private String stringValue = null;
    private Boolean booleanValue = null;
    private boolean ignoreCase = false;

    public Equal(String propertyName, double a) {
        this.propertyName = propertyName;
        this.numberValue = a;
    }

    public Equal(String propertyName, boolean ignoreCase, String a) {
        this.propertyName = propertyName;
        this.stringValue = a;
        this.ignoreCase = ignoreCase;
    }

    public Equal(String propertyName, boolean a) {
        this.propertyName = propertyName;
        this.booleanValue = a;
    }

    @Override
    public boolean accepts(JPPFSystemInformation info) {
        try {
            String s = this.getProperty(info, this.propertyName);
            if (this.numberValue != null) {
                return Double.valueOf(s).doubleValue() == this.numberValue.doubleValue();
            }
            if (this.stringValue != null) {
                return this.ignoreCase ? this.stringValue.equalsIgnoreCase(s) : this.stringValue.equals(s);
            }
            if (this.booleanValue != null) {
                return Boolean.valueOf(s).booleanValue() == this.booleanValue.booleanValue();
            }
            return s == null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (this.computedToString != null) return this.computedToString;
        Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
        synchronized (ExecutionPolicy.class) {
            StringBuilder sb = new StringBuilder();
            sb.append(Equal.indent()).append("<Equal valueType=\"");
            if (this.stringValue != null) {
                sb.append("string");
            } else if (this.numberValue != null) {
                sb.append("numeric");
            } else if (this.booleanValue != null) {
                sb.append("boolean");
            }
            sb.append("\" ignoreCase=\"").append(this.ignoreCase).append("\">\n");
            ++toStringIndent;
            sb.append(Equal.indent()).append("<Property>").append(this.propertyName).append("</Property>\n");
            sb.append(Equal.indent()).append("<Value>");
            if (this.stringValue != null) {
                sb.append(this.stringValue);
            } else if (this.numberValue != null) {
                sb.append(this.numberValue);
            } else if (this.booleanValue != null) {
                sb.append(this.booleanValue);
            }
            sb.append("</Value>\n");
            --toStringIndent;
            sb.append(Equal.indent()).append("</Equal>\n");
            this.computedToString = sb.toString();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.computedToString;
        }
    }
}

