/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.policy;

import java.io.Serializable;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.utils.TypedProperties;

public abstract class ExecutionPolicy
implements Serializable {
    protected static int toStringIndent = 0;
    protected String computedToString = null;

    public abstract boolean accepts(JPPFSystemInformation var1);

    public ExecutionPolicy and(ExecutionPolicy ... rules) {
        return new AndRule(this.makeRuleArray(this, rules));
    }

    public ExecutionPolicy or(ExecutionPolicy ... rules) {
        return new OrRule(this.makeRuleArray(this, rules));
    }

    public ExecutionPolicy xor(ExecutionPolicy ... rules) {
        return new XorRule(this.makeRuleArray(this, rules));
    }

    public ExecutionPolicy not() {
        return new NotRule(this);
    }

    private ExecutionPolicy[] makeRuleArray(ExecutionPolicy rule, ExecutionPolicy[] ruleArray) {
        ExecutionPolicy[] result = new ExecutionPolicy[ruleArray.length + 1];
        int count = 0;
        result[count++] = rule;
        for (ExecutionPolicy r : ruleArray) {
            result[count++] = r;
        }
        return result;
    }

    public String getProperty(JPPFSystemInformation info, String name) {
        TypedProperties[] propsArray;
        for (TypedProperties props : propsArray = new TypedProperties[]{info.getJppf(), info.getSystem(), info.getEnv(), info.getNetwork(), info.getRuntime(), info.getStorage()}) {
            String value = props.getString(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected static String indent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toStringIndent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public static class NotRule
    extends ExecutionPolicy {
        private ExecutionPolicy rule = null;

        public NotRule(ExecutionPolicy rule) {
            this.rule = rule;
        }

        @Override
        public boolean accepts(JPPFSystemInformation info) {
            return !this.rule.accepts(info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            if (this.computedToString != null) return this.computedToString;
            Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
            synchronized (ExecutionPolicy.class) {
                StringBuilder sb = new StringBuilder();
                sb.append(NotRule.indent()).append("<NOT>\n");
                ++toStringIndent;
                if (this.rule == null) {
                    sb.append(NotRule.indent()).append("null\n");
                } else {
                    sb.append(this.rule.toString());
                }
                --toStringIndent;
                sb.append(NotRule.indent()).append("</NOT>\n");
                this.computedToString = sb.toString();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.computedToString;
            }
        }
    }

    public static class XorRule
    extends LogicalRule {
        public XorRule(ExecutionPolicy ... rules) {
            super(rules);
        }

        @Override
        public boolean accepts(JPPFSystemInformation info) {
            if (this.rules == null || this.rules.length <= 0) {
                return true;
            }
            boolean b = this.rules[0].accepts(info);
            if (this.rules.length >= 1) {
                for (int i = 1; i < this.rules.length; ++i) {
                    b = b != this.rules[i].accepts(info);
                }
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String toString() {
            if (this.computedToString != null) return this.computedToString;
            Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
            synchronized (ExecutionPolicy.class) {
                this.computedToString = XorRule.indent() + "<XOR>\n" + super.toString() + XorRule.indent() + "</XOR>\n";
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.computedToString;
            }
        }
    }

    public static class OrRule
    extends LogicalRule {
        public OrRule(ExecutionPolicy ... rules) {
            super(rules);
        }

        @Override
        public boolean accepts(JPPFSystemInformation info) {
            if (this.rules == null || this.rules.length <= 0) {
                return true;
            }
            boolean b = false;
            for (ExecutionPolicy ep : this.rules) {
                b = b || ep.accepts(info);
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String toString() {
            if (this.computedToString != null) return this.computedToString;
            Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
            synchronized (ExecutionPolicy.class) {
                this.computedToString = OrRule.indent() + "<OR>\n" + super.toString() + OrRule.indent() + "</OR>\n";
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.computedToString;
            }
        }
    }

    public static class AndRule
    extends LogicalRule {
        public AndRule(ExecutionPolicy ... rules) {
            super(rules);
        }

        @Override
        public boolean accepts(JPPFSystemInformation info) {
            if (this.rules == null || this.rules.length <= 0) {
                return true;
            }
            boolean b = true;
            for (ExecutionPolicy ep : this.rules) {
                b = b && ep.accepts(info);
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String toString() {
            if (this.computedToString != null) return this.computedToString;
            Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
            synchronized (ExecutionPolicy.class) {
                this.computedToString = AndRule.indent() + "<AND>\n" + super.toString() + AndRule.indent() + "</AND>\n";
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.computedToString;
            }
        }
    }

    public static abstract class LogicalRule
    extends ExecutionPolicy {
        protected ExecutionPolicy[] rules = null;

        public LogicalRule(ExecutionPolicy ... rules) {
            this.rules = rules;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
            synchronized (ExecutionPolicy.class) {
                StringBuilder sb = new StringBuilder();
                ++toStringIndent;
                if (this.rules == null) {
                    sb.append(LogicalRule.indent()).append("null\n");
                } else {
                    for (ExecutionPolicy ep : this.rules) {
                        sb.append(ep.toString());
                    }
                }
                --toStringIndent;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sb.toString();
            }
        }
    }
}

