/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.policy;

import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.policy.ExecutionPolicy;

public class OneOf
extends ExecutionPolicy {
    private String propertyName = null;
    private double[] numberValues = null;
    private String[] stringValues = null;
    private boolean ignoreCase = false;

    public OneOf(String propertyName, double ... values) {
        this.propertyName = propertyName;
        this.numberValues = values;
    }

    public OneOf(String propertyName, boolean ignoreCase, String ... values) {
        this.propertyName = propertyName;
        this.stringValues = values;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accepts(JPPFSystemInformation info) {
        try {
            String s = this.getProperty(info, this.propertyName);
            if (this.numberValues != null) {
                double value = Double.valueOf(s);
                for (double d : this.numberValues) {
                    if (d != value) continue;
                    return true;
                }
            } else if (this.stringValues != null) {
                for (String value : this.stringValues) {
                    if (value == null && s == null) {
                        return true;
                    }
                    if (value == null || s == null) continue;
                    if (!this.ignoreCase && s.equals(value)) {
                        return true;
                    }
                    if (!this.ignoreCase || !s.equalsIgnoreCase(value)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (this.computedToString != null) return this.computedToString;
        Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
        synchronized (ExecutionPolicy.class) {
            StringBuilder sb = new StringBuilder();
            sb.append(OneOf.indent()).append("<OneOf valueType=\"");
            if (this.stringValues != null) {
                sb.append("string");
            } else if (this.numberValues != null) {
                sb.append("numeric");
            }
            sb.append("\" ignoreCase=\"").append(this.ignoreCase).append("\">\n");
            ++toStringIndent;
            sb.append(OneOf.indent()).append("<Property>").append(this.propertyName).append("</Property>\n");
            if (this.stringValues != null) {
                for (String s : this.stringValues) {
                    sb.append(OneOf.indent()).append("<Value>").append(s).append("</Value>\n");
                }
            } else {
                for (double d : this.numberValues) {
                    sb.append(OneOf.indent()).append("<Value>").append(d).append("</Value>\n");
                }
            }
            --toStringIndent;
            sb.append(OneOf.indent()).append("</OneOf>\n");
            this.computedToString = sb.toString();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.computedToString;
        }
    }
}

