/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.policy;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.policy.ExecutionPolicy;

public class RegExp
extends ExecutionPolicy {
    private String propertyName = null;
    private String regExp = null;
    private transient Pattern pattern = null;

    public RegExp(String propertyName, String regExp) throws PatternSyntaxException {
        this.propertyName = propertyName;
        Pattern.compile(regExp);
        this.regExp = regExp;
    }

    @Override
    public boolean accepts(JPPFSystemInformation info) {
        String s;
        if (this.regExp == null) {
            return false;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regExp);
        }
        if ((s = this.getProperty(info, this.propertyName)) == null) {
            return false;
        }
        return this.pattern.matcher(s).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (this.computedToString != null) return this.computedToString;
        Class<ExecutionPolicy> clazz = ExecutionPolicy.class;
        synchronized (ExecutionPolicy.class) {
            StringBuilder sb = new StringBuilder();
            sb.append(RegExp.indent()).append("<RegExp>\n");
            ++toStringIndent;
            sb.append(RegExp.indent()).append("<Property>").append(this.propertyName).append("</Property>\n");
            sb.append(RegExp.indent()).append("<Value>").append(this.regExp).append("</Value>\n");
            --toStringIndent;
            sb.append(RegExp.indent()).append("</RegExp>\n");
            this.computedToString = sb.toString();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.computedToString;
        }
    }
}

