/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jppf.node.screensaver.NodePanel;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

class JPPFScreenSaver {
    private NodePanel node = null;
    private ImageIcon logo = null;
    private int nbLogos = 10;
    private int speed = 10;
    private boolean collisions = false;
    private ImageData[] data = null;
    private Container parent = null;
    private Timer timer = null;
    int imgw = 0;
    int imgh = 0;
    private Image logoImg = null;
    private Image buffer = null;
    private Graphics bufferGraphics = null;

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            for (Frame frame : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(frame);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        JPPFScreenSaver.this.destroy();
                        System.exit(0);
                    }
                });
            }
            Frame frame = Frame.getFrames()[0];
            frame.setExtendedState(6);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initializeSettings();
        this.data = new ImageData[this.nbLogos];
        for (int i = 0; i < this.nbLogos; ++i) {
            this.data[i] = new ImageData();
        }
        this.parent.setBackground(Color.BLACK);
        Dimension fullSize = Toolkit.getDefaultToolkit().getScreenSize();
        boolean activate = true;
        if (this.node == null) {
            this.node = new NodePanel(activate);
        }
        this.node.setDoubleBuffered(true);
        this.parent.add(this.node);
        this.initializeFlyingLogos();
        Dimension dim = this.parent.getSize();
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.nbLogos; ++i) {
            int n = dim.width - this.imgw;
            if (n <= 0) {
                n = this.imgw;
            }
            this.data[i].prevx = this.data[i].x = rand.nextInt(n);
            this.data[i].stepX *= 2 * rand.nextInt(2) - 1;
            n = dim.height - this.imgh;
            if (n <= 0) {
                n = this.imgh;
            }
            this.data[i].prevy = this.data[i].y = rand.nextInt(n);
            this.data[i].stepY *= 2 * rand.nextInt(2) - 1;
        }
        this.setDoubledBuffering(this.node);
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new LogoUpdateTask(), 100L, (long)(25 + 5 * (11 - this.speed)));
            this.timer.schedule((TimerTask)new LogoDisplayTask(), 500L, 25L);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    String s = NodePanel.toStringDuration(System.currentTimeMillis() - ((JPPFScreenSaver)JPPFScreenSaver.this).node.nodeState.startedAt);
                    ((JPPFScreenSaver)JPPFScreenSaver.this).node.nodeState.timeLabel.setText("Active for: " + s);
                }
            };
            this.timer.scheduleAtFixedRate(task, 1000L, 1000L);
        }
    }

    private void initializeSettings() {
        System.setProperty("jppf.config", "jppf-node.properties");
        TypedProperties props = JPPFConfiguration.getProperties();
        props.setProperty("jppf.management.port", "12010");
        this.nbLogos = this.getIntSetting("nbLogos", 5);
        this.speed = this.getIntSetting("speed", 5);
    }

    private void initializeFlyingLogos() {
        this.logo = NodePanel.loadImage("/org/jppf/node/logo-small.gif");
        this.logoImg = this.logo.getImage();
        this.imgw = this.logo.getIconWidth();
        this.imgh = this.logo.getIconHeight();
    }

    private void setDoubledBuffering(JComponent comp) {
        comp.setDoubleBuffered(true);
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            Component c = comp.getComponent(i);
            if (!(c instanceof JComponent)) continue;
            this.setDoubledBuffering((JComponent)c);
        }
    }

    private int getIntSetting(String name, int defValue) {
        int result = defValue;
        return result;
    }

    public void paint(Graphics g) {
    }

    protected void destroy() {
        this.timer.cancel();
        if (this.node != null) {
            this.node.cleanup();
            this.parent.remove(this.node);
            this.node = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLogos() {
        Graphics g = this.parent.getGraphics();
        if (this.buffer == null) {
            this.buffer = this.parent.createImage(this.parent.getWidth(), this.parent.getHeight());
            this.bufferGraphics = this.buffer.getGraphics();
        }
        Shape clip = this.bufferGraphics.getClip();
        ImageData[] arr$ = this.data;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ImageData d;
            ImageData imageData = d = arr$[i$];
            synchronized (imageData) {
                int minx = Math.min(d.prevx, d.x);
                int maxx = Math.max(d.prevx, d.x);
                int miny = Math.min(d.prevy, d.y);
                int maxy = Math.max(d.prevy, d.y);
                int w = maxx - minx + this.imgw;
                int h = maxy - miny + this.imgh;
                this.bufferGraphics.setClip(minx, miny, w, h);
                this.parent.paint(this.bufferGraphics);
                this.bufferGraphics.drawImage(this.logoImg, d.x, d.y, this.parent);
                d.prevx = d.x;
                d.prevy = d.y;
                g.drawImage(this.buffer, minx, miny, minx + w, miny + h, minx, miny, minx + w, miny + h, this.parent);
                continue;
            }
        }
        this.bufferGraphics.setClip(clip);
    }

    private class LogoUpdateTask
    extends TimerTask {
        private LogoUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Dimension dim = JPPFScreenSaver.this.parent.getSize();
            for (int i = 0; i < JPPFScreenSaver.this.data.length; ++i) {
                ImageData d = JPPFScreenSaver.this.data[i];
                if (JPPFScreenSaver.this.collisions) {
                    for (int j = i + 1; j < JPPFScreenSaver.this.data.length; ++j) {
                        ImageData d2 = JPPFScreenSaver.this.data[j];
                        this.checkColliding(d, d2);
                    }
                }
                ImageData imageData = d;
                synchronized (imageData) {
                    if (d.x + d.stepX < 0 || d.x + d.stepX + JPPFScreenSaver.this.imgw > dim.width) {
                        d.stepX = -d.stepX;
                    }
                    if (d.y + d.stepY < 0 || d.y + d.stepY + JPPFScreenSaver.this.imgh > dim.height) {
                        d.stepY = -d.stepY;
                    }
                    d.x += d.stepX;
                    d.y += d.stepY;
                    continue;
                }
            }
        }

        public boolean checkColliding(ImageData d1, ImageData d2) {
            int x1 = d1.x + d1.stepX;
            int x2 = d2.x + d2.stepX;
            int y1 = d1.y + d1.stepY;
            int y2 = d2.y + d2.stepY;
            boolean b = false;
            if (this.isIn(x1, y1, x2, y2)) {
                if (d1.x >= d2.x + JPPFScreenSaver.this.imgw) {
                    d1.stepX = -d1.stepX;
                    d2.stepX = -d2.stepX;
                }
                if (d1.y >= d2.y + JPPFScreenSaver.this.imgh) {
                    d1.stepY = -d1.stepY;
                    d2.stepY = -d2.stepY;
                }
                return true;
            }
            if (this.isIn(x1 + JPPFScreenSaver.this.imgw, y1, x2, y2)) {
                if (d1.x + JPPFScreenSaver.this.imgw <= d2.x) {
                    d1.stepX = -d1.stepX;
                    d2.stepX = -d2.stepX;
                }
                if (d1.y >= d2.y + JPPFScreenSaver.this.imgh) {
                    d1.stepY = -d1.stepY;
                    d2.stepY = -d2.stepY;
                }
                return true;
            }
            if (this.isIn(x1, y1 + JPPFScreenSaver.this.imgh, x2, y2)) {
                if (d1.x >= d2.x + JPPFScreenSaver.this.imgw) {
                    d1.stepX = -d1.stepX;
                    d2.stepX = -d2.stepX;
                }
                if (d1.y + JPPFScreenSaver.this.imgh <= d2.y) {
                    d1.stepY = -d1.stepY;
                    d2.stepY = -d2.stepY;
                }
                return true;
            }
            if (this.isIn(x1 + JPPFScreenSaver.this.imgw, y1 + JPPFScreenSaver.this.imgh, x2, y2)) {
                if (d1.x + JPPFScreenSaver.this.imgw <= d2.x) {
                    d1.stepX = -d1.stepX;
                    d2.stepX = -d2.stepX;
                }
                if (d1.y + JPPFScreenSaver.this.imgh <= d2.y) {
                    d1.stepY = -d1.stepY;
                    d2.stepY = -d2.stepY;
                }
                return true;
            }
            return false;
        }

        public boolean isIn(int x1, int y1, int x2, int y2) {
            return x1 >= x2 && x1 <= x2 + JPPFScreenSaver.this.imgw && y1 >= y2 && y1 <= y2 + JPPFScreenSaver.this.imgh;
        }
    }

    public class LogoDisplayTask
    extends TimerTask {
        Runnable task = null;

        public LogoDisplayTask() {
            this.task = new Runnable(){

                @Override
                public void run() {
                    JPPFScreenSaver.this.updateLogos();
                }
            };
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(this.task);
        }
    }

    private static class ImageData {
        public int prevx = 0;
        public int prevy = 0;
        public int x = 0;
        public int y = 0;
        public int stepX = 1;
        public int stepY = 1;

        private ImageData() {
        }
    }
}

