/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.node.screensaver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jppf.node.screensaver.NodeState;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;

class NodePanel
extends JPanel {
    public static final String IMAGE_PATH = "/org/jppf/node";
    static final ImageIcon BRIGHT_GREEN = NodePanel.loadImage("/org/jppf/node/active_greenlight.gif");
    static final ImageIcon DARK_GREEN = NodePanel.loadImage("/org/jppf/node/inactive_greenlight.gif");
    static final ImageIcon BRIGHT_RED = NodePanel.loadImage("/org/jppf/node/active_redlight.gif");
    static final ImageIcon DARK_RED = NodePanel.loadImage("/org/jppf/node/inactive_redlight.gif");
    public transient NodeState nodeState = null;
    private boolean activate = true;
    private static NumberFormat integerFormatter = null;

    public NodePanel(boolean activate) {
        this.activate = activate;
        this.init();
    }

    public void init() {
        try {
            String log4jCfg = "log4j-node.properties";
            System.setProperty("log4j.configuration", log4jCfg);
            TypedProperties props = JPPFConfiguration.getProperties();
            props.remove("jppf.policy.file");
            this.createUI();
            if (this.activate) {
                this.nodeState.startNode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createUI() {
        GridBagLayout g = new GridBagLayout();
        this.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        this.setBackground(Color.BLACK);
        ImageIcon logo = NodePanel.loadImage("/org/jppf/node/jppf-at-home.gif");
        JLabel logoLabel = new JLabel(logo);
        this.addLayoutComp(this, g, c, logoLabel);
        this.addLayoutComp(this, g, c, Box.createVerticalStrut(10));
        this.addLayoutComp(this, g, c, this.createNodePanel());
        this.addLayoutComp(this, g, c, Box.createVerticalStrut(5));
    }

    private JPanel createNodePanel() {
        JPanel panel = new JPanel();
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        panel.setLayout(g);
        panel.setBackground(Color.BLACK);
        this.nodeState = new NodeState();
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(25));
        JLabel label = new JLabel("JPPF Node");
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        this.addLayoutComp(panel, g, c, label);
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(50));
        this.addLayoutComp(panel, g, c, this.nodeState.timeLabel);
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(25));
        this.addLayoutComp(panel, g, c, this.makeStatusPanel(0, "connection"));
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(15));
        this.addLayoutComp(panel, g, c, this.makeStatusPanel(1, "execution"));
        this.addLayoutComp(panel, g, c, Box.createHorizontalStrut(15));
        label = new JLabel("tasks");
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        this.addLayoutComp(panel, g, c, label);
        panel.add(Box.createHorizontalStrut(5));
        this.nodeState.countLabel.setPreferredSize(new Dimension(60, 20));
        this.addLayoutComp(panel, g, c, this.nodeState.countLabel);
        return panel;
    }

    private void addLayoutComp(JPanel panel, GridBagLayout g, GridBagConstraints c, Component comp) {
        g.setConstraints(comp, c);
        panel.add(comp);
    }

    private JPanel makeStatusPanel(int statusIdx, String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(Color.BLACK);
        JLabel label = new JLabel(text);
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(label);
        labelPanel.setBackground(Color.BLACK);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        statusPanel.setBackground(Color.BLACK);
        statusPanel.add(this.nodeState.statusLabels[statusIdx][0]);
        statusPanel.add(Box.createVerticalStrut(4));
        statusPanel.add(this.nodeState.statusLabels[statusIdx][1]);
        labelPanel.setPreferredSize(new Dimension(60, 20));
        panel.add(labelPanel);
        panel.add(Box.createHorizontalStrut(5));
        statusPanel.setPreferredSize(new Dimension(8, 20));
        panel.add(statusPanel);
        panel.setPreferredSize(new Dimension(73, 20));
        return panel;
    }

    public static ImageIcon loadImage(String file) {
        int MAX_IMAGE_SIZE = 15000;
        int count = 0;
        InputStream is = NodePanel.class.getResourceAsStream(file);
        if (is == null) {
            System.err.println("Couldn't find file: " + file);
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buf = new byte[MAX_IMAGE_SIZE];
        try {
            count = bis.read(buf);
            bis.close();
        }
        catch (IOException ioe) {
            System.err.println("Couldn't read stream from file: " + file);
            ioe.printStackTrace();
            return null;
        }
        if (count <= 0) {
            System.err.println("Empty file: " + file);
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
    }

    public void cleanup() {
        try {
            if (this.activate) {
                this.nodeState.stopNode();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String toStringDuration(long elapsed) {
        if (integerFormatter == null) {
            integerFormatter = NumberFormat.getInstance();
            integerFormatter.setGroupingUsed(false);
            integerFormatter.setMinimumFractionDigits(0);
            integerFormatter.setMaximumFractionDigits(0);
            integerFormatter.setMinimumIntegerDigits(2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(integerFormatter.format(elapsed / 3600000L)).append(" hrs ");
        sb.append(integerFormatter.format((elapsed %= 3600000L) / 60000L)).append(" mn ");
        sb.append(integerFormatter.format((elapsed %= 60000L) / 1000L));
        sb.append(" sec");
        return sb.toString();
    }
}

