/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.node.idle.IdleDetector;
import org.jppf.node.idle.IdleState;
import org.jppf.node.idle.IdleStateEvent;
import org.jppf.node.idle.IdleStateListener;
import org.jppf.process.ProcessWrapper;
import org.jppf.process.event.ProcessWrapperEvent;
import org.jppf.process.event.ProcessWrapperEventListener;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLauncher
extends ThreadSynchronization
implements Runnable,
ProcessWrapperEventListener,
IdleStateListener {
    private static Logger log = LoggerFactory.getLogger(ProcessLauncher.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Process process = null;
    private ServerSocket processServer = null;
    private int processPort = 0;
    private String mainClass = null;
    private AtomicBoolean stoppedOnBusyState = new AtomicBoolean(false);
    private AtomicBoolean idle = new AtomicBoolean(false);
    private boolean idleMode = false;
    private IdleDetector idleDetector = null;

    public ProcessLauncher(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public void run() {
        this.idleMode = JPPFConfiguration.getProperties().getBoolean("jppf.idle.mode.enabled", false);
        boolean end = false;
        try {
            this.createShutdownHook();
            this.startDriverSocket();
            if (this.idleMode) {
                this.idleDetector = new IdleDetector(this);
                System.out.println("Node running in \"Idle Host\" mode");
                this.idleDetector.run();
            }
            while (!end) {
                if (this.idleMode) {
                    while (!this.idle.get()) {
                        this.goToSleep();
                    }
                }
                this.startProcess();
                int n = this.process.waitFor();
                end = this.onProcessExit(n);
                if (this.process == null) continue;
                this.process.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void startProcess() throws Exception {
        this.stoppedOnBusyState.set(false);
        this.process = this.buildProcess();
        ProcessWrapper wrapper = this.createProcessWrapper(this.process);
        if (debugEnabled) {
            log.debug("started driver process [" + this.process + "]");
        }
    }

    public Process buildProcess() throws Exception {
        TypedProperties config = JPPFConfiguration.getProperties();
        ArrayList<String> jvmOptions = new ArrayList<String>();
        ArrayList<String> cpElements = new ArrayList<String>();
        cpElements.add(System.getProperty("java.class.path"));
        String s = config.getString("jppf.jvm.options");
        if (s == null) {
            s = config.getString("other.jvm.options");
        }
        if (s != null) {
            String[] options = s.split("\\s");
            int count = 0;
            while (count < options.length) {
                String option;
                if ("-cp".equalsIgnoreCase(option = options[count++]) || "-classpath".equalsIgnoreCase(option)) {
                    cpElements.add(options[count++]);
                    continue;
                }
                jvmOptions.add(option);
            }
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(System.getProperty("java.home") + "/bin/java");
        command.add("-cp");
        StringBuilder sb = new StringBuilder();
        String sep = System.getProperty("path.separator");
        for (int i = 0; i < cpElements.size(); ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append((String)cpElements.get(i));
        }
        command.add(sb.toString());
        command.add("-Djppf.config=" + System.getProperty("jppf.config"));
        command.add("-Dlog4j.configuration=" + System.getProperty("log4j.configuration"));
        for (String opt : jvmOptions) {
            command.add(opt);
        }
        command.add(this.mainClass);
        command.add("" + this.processPort);
        if (debugEnabled) {
            log.debug("process command:\n" + command);
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        return builder.start();
    }

    private ProcessWrapper createProcessWrapper(Process p) {
        ProcessWrapper wrapper = new ProcessWrapper(this.process);
        wrapper.addListener(this);
        return wrapper;
    }

    private boolean onProcessExit(int n) {
        String s = this.getOutput(this.process, "std").trim();
        if (s.length() > 0) {
            System.out.println("\nstandard output:\n" + s);
            log.info("standard output:\n" + s);
        }
        if ((s = this.getOutput(this.process, "err").trim()).length() > 0) {
            System.out.println("\nerror output:\n" + s);
            log.info("error output:\n" + s);
        }
        return n != 2 && !this.stoppedOnBusyState.get();
    }

    protected void createShutdownHook() {
        Runnable hook = new Runnable(){

            @Override
            public void run() {
                if (ProcessLauncher.this.process != null) {
                    ProcessLauncher.this.process.destroy();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(hook));
    }

    protected int startDriverSocket() {
        try {
            this.processServer = new ServerSocket(0);
            this.processPort = this.processServer.getLocalPort();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket s = ProcessLauncher.this.processServer.accept();
                                s.getInputStream().read();
                            }
                        }
                        catch (IOException ioe) {
                            if (!debugEnabled) continue;
                            log.debug(ioe.getMessage(), (Throwable)ioe);
                            continue;
                        }
                        break;
                    }
                }
            };
            new Thread(r).start();
        }
        catch (Exception e) {
            try {
                this.processServer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if (debugEnabled) {
                    log.debug(ioe.getMessage(), (Throwable)ioe);
                }
                System.exit(1);
            }
        }
        return this.processPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutput(Process process, String streamType) {
        StringBuilder sb = new StringBuilder();
        try {
            InputStream is = "std".equals(streamType) ? process.getInputStream() : process.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            try {
                String s = "";
                while (s != null) {
                    s = reader.readLine();
                    if (s == null) continue;
                    sb.append(s).append("\n");
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public void errorStreamAltered(ProcessWrapperEvent event) {
        System.err.print(event.getContent());
    }

    @Override
    public void outputStreamAltered(ProcessWrapperEvent event) {
        System.out.print(event.getContent());
    }

    @Override
    public void idleStateChanged(IdleStateEvent event) {
        IdleState state = event.getState();
        if (IdleState.BUSY.equals((Object)state)) {
            if (this.idleMode && this.process != null) {
                this.idle.set(false);
                this.stoppedOnBusyState.set(true);
                this.process.destroy();
            }
        } else {
            this.idle.set(true);
            this.wakeUp();
        }
    }
}

