/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.jppf.process.event.ProcessWrapperEvent;
import org.jppf.process.event.ProcessWrapperEventListener;
import org.jppf.utils.EventEmitter;

public final class ProcessWrapper
extends EventEmitter<ProcessWrapperEventListener> {
    private Process process = null;

    public ProcessWrapper() {
    }

    public ProcessWrapper(Process process) {
        this.setProcess(process);
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        if (this.process == null) {
            this.process = process;
            new StreamHandler(process.getInputStream(), true).start();
            new StreamHandler(process.getErrorStream(), false).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fireStreamEvent(boolean output, String content) {
        List listeners;
        ProcessWrapperEvent event = new ProcessWrapperEvent(content);
        List list = listeners = this.getListeners();
        synchronized (list) {
            for (ProcessWrapperEventListener listener : listeners) {
                if (output) {
                    listener.outputStreamAltered(event);
                    continue;
                }
                listener.errorStreamAltered(event);
            }
        }
    }

    private class StreamHandler
    extends Thread {
        private boolean output = true;
        private InputStream is = null;

        public StreamHandler(InputStream is, boolean output) {
            this.is = is;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                int c;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                boolean end = false;
                int bufferSize = 8192;
                StringBuilder sb = new StringBuilder(bufferSize);
                int count = 0;
                while (!end && (c = reader.read()) != -1) {
                    if (c == 13) continue;
                    ++count;
                    sb.append((char)c);
                    if (sb.length() < bufferSize && c != 10) continue;
                    ProcessWrapper.this.fireStreamEvent(this.output, sb.toString());
                    sb = new StringBuilder(bufferSize);
                }
                Thread.sleep(1L);
            }
            catch (IOException ignore) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

