/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DHParameterSpec;
import org.jppf.utils.FileUtils;
import org.jppf.utils.StringUtils;

public class CryptoUtils {
    private static PrivateKey privateKey = null;
    private static PublicKey publicKey = null;
    private static SecretKey secretKey = null;

    public static void main(String ... args) {
        try {
            SecretKey key = CryptoUtils.generateSecretKey();
            FileOutputStream fos = new FileOutputStream("sk.bin");
            fos.write(key.getEncoded());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static KeyPair generateKeyPair() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        random.setSeed(System.currentTimeMillis());
        keyGen.initialize(1024, random);
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey privateKey = pair.getPrivate();
        PublicKey publicKey = pair.getPublic();
        byte[] bytes = privateKey.getEncoded();
        System.out.println("Private key: " + StringUtils.dumpBytes(bytes, 0, bytes.length));
        bytes = publicKey.getEncoded();
        System.out.println("Public key: " + StringUtils.dumpBytes(bytes, 0, bytes.length));
        return pair;
    }

    public static KeyPair generateDHKeyPair() throws Exception {
        DHParameterSpec paramSpec = null;
        AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
        paramGen.init(512);
        AlgorithmParameters params = paramGen.generateParameters();
        paramSpec = params.getParameterSpec(DHParameterSpec.class);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
        keyGen.initialize(paramSpec);
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey privateKey = pair.getPrivate();
        PublicKey publicKey = pair.getPublic();
        byte[] bytes = privateKey.getEncoded();
        System.out.println("Private DH key: " + StringUtils.dumpBytes(bytes, 0, bytes.length));
        bytes = publicKey.getEncoded();
        System.out.println("Public DH key: " + StringUtils.dumpBytes(bytes, 0, bytes.length));
        return pair;
    }

    public static SecretKey generateSecretKey() throws Exception {
        KeyGenerator gen = KeyGenerator.getInstance("DES");
        gen.init(56);
        return gen.generateKey();
    }

    public static byte[] readKeyFile(String filename) throws IOException {
        InputStream is = null;
        File file = new File(filename);
        is = file.exists() ? new FileInputStream(file) : CryptoUtils.class.getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new FileNotFoundException("could not find file: " + filename);
        }
        String hexString = FileUtils.readTextFile(new InputStreamReader(is));
        return StringUtils.toBytes(hexString);
    }

    public static byte[] generateSignature(byte[] data) throws Exception {
        Signature sig = Signature.getInstance("SHA1withDSA");
        sig.initSign(CryptoUtils.getPrivateKey());
        sig.update(data);
        byte[] signature = sig.sign();
        return signature;
    }

    public static boolean verifySignature(byte[] signature, byte[] data) throws Exception {
        Signature sig = Signature.getInstance("SHA1withDSA");
        sig.initVerify(CryptoUtils.getPublicKey());
        sig.update(data);
        return sig.verify(signature);
    }

    private static PrivateKey getPrivateKey() throws Exception {
        if (privateKey == null) {
            byte[] priv = CryptoUtils.readKeyFile("config/PrivateKey.txt");
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(priv);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            privateKey = keyFactory.generatePrivate(privKeySpec);
        }
        return privateKey;
    }

    private static PublicKey getPublicKey() throws Exception {
        if (publicKey == null) {
            byte[] pub = CryptoUtils.readKeyFile("config/PublicKey.txt");
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pub);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            publicKey = keyFactory.generatePublic(pubKeySpec);
        }
        return publicKey;
    }

    public static SecretKey getSecretKey() throws Exception {
        if (secretKey == null) {
            byte[] pub = CryptoUtils.readKeyFile("org/jppf/resources/SecretKey.txt");
            DESKeySpec spec = new DESKeySpec(pub);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            secretKey = skf.generateSecret(spec);
        }
        return secretKey;
    }

    public static SecretKey getSecretKeyFromEncoded(byte[] encoded) throws Exception {
        DESKeySpec spec = new DESKeySpec(encoded);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
        return skf.generateSecret(spec);
    }

    public static byte[] encrypt(byte[] data) throws Exception {
        return CryptoUtils.encrypt(CryptoUtils.getSecretKey(), data);
    }

    public static byte[] encrypt(SecretKey key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data) throws Exception {
        return CryptoUtils.decrypt(CryptoUtils.getSecretKey(), data);
    }

    public static byte[] decrypt(SecretKey key, byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, key);
        return cipher.doFinal(data);
    }
}

