/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.jppf.security.JPPFPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFPermissions
extends PermissionCollection {
    private static Logger log = LoggerFactory.getLogger(JPPFPolicy.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private List<Permission> permissions = new Vector<Permission>();

    @Override
    public synchronized void add(Permission permission) {
        if (permission == null) {
            return;
        }
        this.permissions.add(permission);
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        return new Enumerator();
    }

    @Override
    public synchronized boolean implies(Permission permission) {
        RuntimePermission rtp;
        String actions;
        if (permission instanceof RuntimePermission && (actions = (rtp = (RuntimePermission)permission).getActions()) != null && actions.indexOf("exitVM") >= 0) {
            boolean breakpoint = false;
        }
        List<Permission> perms = Collections.unmodifiableList(this.permissions);
        for (Permission p : perms) {
            if (!p.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReadOnly() {
    }

    private class Enumerator
    implements Enumeration<Permission> {
        private int index = 0;
        private int count = 0;
        private List<Permission> enumPermissions = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumerator() {
            JPPFPermissions jPPFPermissions2 = JPPFPermissions.this;
            synchronized (jPPFPermissions2) {
                this.enumPermissions = new Vector<Permission>();
                this.enumPermissions.addAll(JPPFPermissions.this.permissions);
            }
            this.count = this.enumPermissions.size();
        }

        @Override
        public boolean hasMoreElements() {
            return this.count > this.index;
        }

        @Override
        public Permission nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("no more element in this enumeration");
            }
            return this.enumPermissions.get(this.index++);
        }
    }
}

