/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.serialization;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jppf.JPPFError;
import org.jppf.serialization.JPPFConfigurationObjectStreamBuilder;
import org.jppf.serialization.JPPFObjectStreamBuilder;
import org.jppf.serialization.JPPFObjectStreamBuilderImpl;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFObjectStreamFactory {
    private static final String OIS_CLASS = "jppf.object.input.stream.class";
    private static final String OOS_CLASS = "jppf.object.output.stream.class";
    private static final String BUILDER_CLASS = "jppf.object.stream.builder";
    private static Logger log = LoggerFactory.getLogger(JPPFObjectStreamFactory.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static JPPFObjectStreamBuilder builder = JPPFObjectStreamFactory.initializeBuilder();

    private static JPPFObjectStreamBuilder initializeBuilder() {
        Object result = null;
        TypedProperties props = JPPFConfiguration.getProperties();
        String oisName = props.getString(OIS_CLASS);
        String oosName = props.getString(OOS_CLASS);
        if (oisName != null && oosName != null) {
            try {
                return new JPPFConfigurationObjectStreamBuilder(oisName, oosName);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Could not instantiate object stream builder for [").append(OIS_CLASS).append(" = ").append(oisName);
                sb.append(", ").append(OOS_CLASS).append(" = ").append(oosName).append("]\nTerminating this application\n");
                log.error(sb.toString() + e.getMessage(), (Throwable)e);
                throw new JPPFError(sb.toString() + e.getMessage(), e);
            }
        }
        String builderName = props.getString(BUILDER_CLASS);
        if (builderName != null) {
            try {
                return (JPPFObjectStreamBuilder)Class.forName(builderName).newInstance();
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Could not instantiate object stream builder for [").append(BUILDER_CLASS).append(" = ");
                sb.append(builderName).append("]\nTerminating this application\n");
                log.error(sb.toString() + e.getMessage(), (Throwable)e);
                throw new JPPFError(sb.toString() + e.getMessage(), e);
            }
        }
        return new JPPFObjectStreamBuilderImpl();
    }

    public static ObjectInputStream newObjectInputStream(InputStream in) throws Exception {
        return builder.newObjectInputStream(in);
    }

    public static ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return builder.newObjectOutputStream(out);
    }
}

