/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.util.concurrent.atomic.AtomicLong;
import org.jppf.server.nio.ChannelSelector;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.utils.ThreadSynchronization;

public abstract class AbstractChannelWrapper<S>
extends ThreadSynchronization
implements ChannelWrapper<S> {
    private static AtomicLong instanceCount = new AtomicLong(0L);
    protected final long id = instanceCount.incrementAndGet();
    protected S channel;
    protected ChannelSelector selector = null;

    public AbstractChannelWrapper(S channel) {
        this.channel = channel;
    }

    @Override
    public S getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public abstract NioContext getContext();

    @Override
    public boolean isOpen() {
        return true;
    }

    public int hashCode() {
        return this.channel == null ? 0 : this.channel.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractChannelWrapper other = (AbstractChannelWrapper)obj;
        if (this.channel == null) {
            return other.channel == null;
        }
        return this.channel.equals(other.channel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.getId());
        sb.append(",").append(" readyOps=").append(this.getReadyOps());
        sb.append(",").append(" keyOps=").append(this.getKeyOps());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int getKeyOps() {
        return 0;
    }

    @Override
    public void setKeyOps(int keyOps) {
    }

    @Override
    public abstract int getReadyOps();

    @Override
    public boolean isReadable() {
        return (this.getReadyOps() & 1) != 0;
    }

    @Override
    public boolean isWritable() {
        return (this.getReadyOps() & 4) != 0;
    }

    @Override
    public boolean isAcceptable() {
        return (this.getReadyOps() & 0x10) != 0;
    }

    @Override
    public boolean isConnectable() {
        return (this.getReadyOps() & 8) != 0;
    }

    @Override
    public ChannelSelector getSelector() {
        return this.selector;
    }

    @Override
    public void setSelector(ChannelSelector selector) {
        this.selector = selector;
    }

    public String getId() {
        return "id=" + this.id;
    }
}

