/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.server.nio.AbstractChannelWrapper;
import org.jppf.server.nio.AbstractNioContext;
import org.jppf.server.nio.NioContext;
import org.jppf.utils.SimpleObjectLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractLocalChannelWrapper<S, T extends AbstractNioContext>
extends AbstractChannelWrapper<T> {
    static Logger log = LoggerFactory.getLogger(AbstractLocalChannelWrapper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    protected AtomicInteger keyOps = new AtomicInteger(0);
    protected AtomicInteger readyOps = new AtomicInteger(0);
    protected S nodeResource = null;
    protected S serverResource = null;
    protected final SimpleObjectLock nodeLock = new SimpleObjectLock();
    protected final SimpleObjectLock serverLock = new SimpleObjectLock();

    public AbstractLocalChannelWrapper(T context) {
        super(context);
        if (traceEnabled) {
            log.trace("created " + this);
        }
    }

    @Override
    public NioContext getContext() {
        return (NioContext)this.getChannel();
    }

    @Override
    public int getKeyOps() {
        return this.keyOps.get();
    }

    @Override
    public void setKeyOps(int keyOps) {
        this.keyOps.set(keyOps);
        if (traceEnabled) {
            log.debug("id=" + this.id + ", readyOps=" + this.readyOps + ", keyOps=" + keyOps);
        }
        if (this.getSelector() != null) {
            this.getSelector().wakeUp();
        }
    }

    @Override
    public int getReadyOps() {
        return this.readyOps.get();
    }

    public void setReadyOps(int readyOps) {
        this.readyOps.set(readyOps);
        if (traceEnabled) {
            log.debug("id=" + this.id + ", readyOps=" + readyOps + ", keyOps=" + this.keyOps);
        }
        if (this.getSelector() != null) {
            this.getSelector().wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getNodeResource() {
        SimpleObjectLock simpleObjectLock = this.nodeLock;
        synchronized (simpleObjectLock) {
            return this.nodeResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeResource(S resource) {
        SimpleObjectLock simpleObjectLock = this.nodeLock;
        synchronized (simpleObjectLock) {
            this.nodeResource = resource;
        }
        this.nodeLock.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getServerResource() {
        SimpleObjectLock simpleObjectLock = this.serverLock;
        synchronized (simpleObjectLock) {
            return this.serverResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerResource(S serverResource) {
        SimpleObjectLock simpleObjectLock = this.serverLock;
        synchronized (simpleObjectLock) {
            this.serverResource = serverResource;
        }
        this.serverLock.wakeUp();
    }

    public SimpleObjectLock getNodeLock() {
        return this.nodeLock;
    }

    public SimpleObjectLock getServerLock() {
        return this.serverLock;
    }
}

