/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.startup;

import java.util.Iterator;
import org.jppf.startup.JPPFStartup;
import org.jppf.utils.ServiceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFStartupLoader<S extends JPPFStartup> {
    private static Logger log = LoggerFactory.getLogger(JPPFStartupLoader.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public void load(Class<S> clazz) {
        Iterator<S> it = ServiceFinder.lookupProviders(clazz);
        while (it.hasNext()) {
            try {
                JPPFStartup s = (JPPFStartup)it.next();
                s.run();
                if (!debugEnabled) continue;
                log.debug("successful run of startup class " + s.getClass().getName());
            }
            catch (Error e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

