/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jppf.utils.JPPFByteArrayOutputStream;

public final class FileUtils {
    private static final int TEMP_BUFFER_SIZE = 32768;

    private FileUtils() {
    }

    public static String readTextFile(Reader aReader) throws IOException {
        BufferedReader reader = aReader instanceof BufferedReader ? (BufferedReader)aReader : new BufferedReader(aReader);
        StringBuilder sb = new StringBuilder();
        String s = "";
        while (s != null) {
            s = reader.readLine();
            if (s == null) continue;
            sb.append(s).append("\n");
        }
        return sb.toString();
    }

    public static List<String> textFileAsLines(Reader aReader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = aReader instanceof BufferedReader ? (BufferedReader)aReader : new BufferedReader(aReader);
        String s = "";
        while (s != null) {
            s = reader.readLine();
            if (s == null) continue;
            lines.add(s);
        }
        return lines;
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtils.readTextFile(new FileReader(file));
    }

    public static String readTextFile(String filename) throws IOException {
        InputStreamReader reader = null;
        File f = new File(filename);
        if (f.exists()) {
            reader = new FileReader(filename);
        } else {
            InputStream is = FileUtils.class.getClassLoader().getResourceAsStream(filename);
            if (is == null) {
                return null;
            }
            reader = new InputStreamReader(is);
        }
        return FileUtils.readTextFile(reader);
    }

    public static void writeTextFile(String filename, String content) throws IOException {
        FileUtils.writeTextFile(new FileWriter(filename), content);
    }

    public static void writeTextFile(File file, String content) throws IOException {
        FileUtils.writeTextFile(new FileWriter(file), content);
    }

    public static void writeTextFile(Writer dest, String content) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(content));
        Writer writer = dest instanceof BufferedWriter ? dest : new BufferedWriter(dest);
        String s = "";
        while (s != null) {
            s = reader.readLine();
            if (s == null) continue;
            writer.write(s);
            writer.write("\n");
        }
        writer.flush();
        writer.close();
    }

    public static InputStream getFileInputStream(String path) throws IOException {
        InputStream is = null;
        File file = new File(path);
        if (file.exists()) {
            is = new BufferedInputStream(new FileInputStream(file));
        }
        if (is == null) {
            URL url = FileUtils.class.getClassLoader().getResource(path);
            is = url == null ? null : url.openStream();
        }
        return is;
    }

    public static OutputStream getFileOutputStream(String path) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(path));
    }

    public static Reader getFileReader(String path) throws IOException {
        InputStream is = FileUtils.getFileInputStream(path);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is);
    }

    public static List<String> getFilePathList(String fileListPath) throws IOException {
        InputStream is = FileUtils.getFileInputStream(fileListPath);
        String content = FileUtils.readTextFile(new BufferedReader(new InputStreamReader(is)));
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        ArrayList<String> filePaths = new ArrayList<String>();
        boolean end = false;
        while (!end) {
            String s = reader.readLine();
            if (s != null) {
                filePaths.add(s);
                continue;
            }
            end = true;
        }
        return filePaths;
    }

    public static String getFileExtension(String filePath) {
        return FileUtils.getFileExtension(new File(filePath));
    }

    public static String getFileExtension(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        String filePath = file.getPath();
        int idx = filePath.lastIndexOf(".");
        if (idx >= 0) {
            return filePath.substring(idx + 1);
        }
        return null;
    }

    public static void splitTextFile(String file, int splitSize) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        String s = "";
        int count = 0;
        while (s != null && (s = reader.readLine()) != null) {
            sb.append(s).append("\n");
            if (sb.length() < splitSize) continue;
            FileUtils.writeTextFile(file + "." + ++count, sb.toString());
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            FileUtils.writeTextFile(file + "." + ++count, sb.toString());
        }
        reader.close();
    }

    public static void main(String ... args) {
        try {
            int size = Integer.valueOf(args[1]);
            FileUtils.splitTextFile(args[0], size);
            System.out.println("Done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] getFileAsByte(String path) throws IOException {
        return FileUtils.getFileAsByte(new File(path));
    }

    public static byte[] getFileAsByte(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        byte[] data = FileUtils.getInputStreamAsByte(is);
        ((InputStream)is).close();
        return data;
    }

    public static byte[] getInputStreamAsByte(InputStream is) throws IOException {
        byte[] buffer = new byte[32768];
        byte[] result = null;
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream();
        boolean end = false;
        while (!end) {
            int n = is.read(buffer, 0, buffer.length);
            if (n < 0) {
                end = true;
                continue;
            }
            baos.write(buffer, 0, n);
        }
        is.close();
        baos.flush();
        result = ((ByteArrayOutputStream)baos).toByteArray();
        baos.close();
        return result;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] bytes = new byte[32768];
        while ((n = is.read(bytes)) > 0) {
            os.write(bytes, 0, n);
        }
    }

    public static File[] toFiles(File dir, String ... names) {
        int len = names.length;
        File[] files = new File[len];
        for (int i = 0; i < len; ++i) {
            files[i] = new File(dir.getPath() + System.getProperty("file.separator") + names[i]);
        }
        return files;
    }

    public static URL[] toURLs(File ... files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = files[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urls;
    }

    public static void writeBytesToStream(byte[] data, OutputStream os) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        FileUtils.copyStream(bais, os);
        bais.close();
    }

    public static void writeBytesToFile(byte[] data, String path) throws IOException {
        FileUtils.writeBytesToFile(data, new File(path));
    }

    public static void writeBytesToFile(byte[] data, File path) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path));
        FileUtils.copyStream(bais, os);
        bais.close();
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }
}

