/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFConfiguration {
    private static Logger log = LoggerFactory.getLogger(JPPFConfiguration.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    public static final String CONFIG_PROPERTY = "jppf.config";
    public static final String CONFIG_PLUGIN_PROPERTY = "jppf.config.plugin";
    public static final String DEFAULT_FILE = "jppf.properties";
    private static TypedProperties props = null;

    public static TypedProperties getProperties() {
        if (props == null) {
            JPPFConfiguration.loadProperties();
        }
        return props;
    }

    public static void reset() {
        JPPFConfiguration.loadProperties();
    }

    private static void loadProperties() {
        props = new TypedProperties();
        try {
            InputStream is = JPPFConfiguration.getStream();
            if (is != null) {
                props.load(is);
            }
        }
        catch (Exception e) {
            log.error("error reading the configuration", (Throwable)e);
        }
    }

    private static InputStream getStream() throws Exception {
        String altSource = System.getProperty(CONFIG_PLUGIN_PROPERTY);
        if (altSource == null) {
            String filename = System.getProperty(CONFIG_PROPERTY, DEFAULT_FILE);
            if (log.isDebugEnabled()) {
                log.debug("reading JPPF configuration file: " + filename);
            }
            InputStream is = null;
            File file = new File(filename);
            if (file.exists()) {
                is = new BufferedInputStream(new FileInputStream(filename));
            }
            if (is == null) {
                is = JPPFConfiguration.class.getClassLoader().getResourceAsStream(filename);
            }
            return is;
        }
        if (log.isDebugEnabled()) {
            log.debug("reading JPPF configuration from alternate source: " + altSource);
        }
        ConfigurationSource source = (ConfigurationSource)Class.forName(altSource).newInstance();
        return source.getPropertyStream();
    }

    public static interface ConfigurationSource {
        public InputStream getPropertyStream() throws IOException;
    }
}

