/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class JPPFThreadFactory
implements ThreadFactory {
    private String name = null;
    private AtomicInteger count = new AtomicInteger(0);
    private boolean monitoringEnabled = false;
    private List<Long> threadIDs = null;
    private ThreadGroup threadGroup = null;
    private int priority = 5;

    public JPPFThreadFactory(String name) {
        this(name, false, 5);
    }

    public JPPFThreadFactory(String name, int priority) {
        this(name, false, priority);
    }

    public JPPFThreadFactory(String name, boolean monitoringEnabled) {
        this(name, monitoringEnabled, 5);
    }

    public JPPFThreadFactory(String name, boolean monitoringEnabled, int priority) {
        this.name = name == null ? "JPPFThreadFactory" : name;
        this.threadGroup = new ThreadGroup(this.name + " thread group");
        this.threadGroup.setMaxPriority(10);
        this.monitoringEnabled = monitoringEnabled;
        if (monitoringEnabled) {
            this.threadIDs = new ArrayList<Long>();
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.threadGroup, r, this.name + "-thread-" + this.incrementCount());
        if (this.monitoringEnabled) {
            this.threadIDs.add(thread.getId());
        }
        thread.setPriority(this.priority);
        return thread;
    }

    public List<Long> getThreadIDs() {
        if (!this.monitoringEnabled) {
            return null;
        }
        return Collections.unmodifiableList(this.threadIDs);
    }

    private int incrementCount() {
        return this.count.incrementAndGet();
    }

    public synchronized void updatePriority(int newPriority) {
        if (newPriority < 1 || newPriority > 10 || this.priority == newPriority) {
            return;
        }
        int count = this.threadGroup.activeCount();
        Thread[] threads = new Thread[2 * count];
        int n = this.threadGroup.enumerate(threads);
        for (int i = 0; i < n; ++i) {
            threads[i].setPriority(newPriority);
        }
        this.priority = newPriority;
    }

    public synchronized int getPriority() {
        return this.priority;
    }
}

