/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.Serializable;
import java.util.Random;

public class JPPFUuid
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String[] ALPHABET_SUPERSET = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "'", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "{", "}", "[", "]", "-", "=", "/", ",", ".", "?", ":", ";"};
    public static final String[] ALPHA_NUM = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String[] HEXADECIMAL = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String[] DECIMAL = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static Random rand = new Random(System.currentTimeMillis());
    private String uuid = null;
    private String[] codes = ALPHABET_SUPERSET;
    private int length = 16;

    public JPPFUuid() {
        this(ALPHABET_SUPERSET, 16);
    }

    public JPPFUuid(String[] codes, int length) {
        if (codes != null && codes.length > 0) {
            this.codes = codes;
        }
        if (length > 0) {
            this.length = length;
        }
        this.uuid = this.generateUuid();
    }

    private String generateUuid() {
        int len = this.codes.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.codes[rand.nextInt(len)]);
        }
        return sb.toString();
    }

    public String toString() {
        return this.uuid;
    }
}

