/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleBuffersOutputStream
extends OutputStream {
    private static Logger log = LoggerFactory.getLogger(MultipleBuffersOutputStream.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private int defaultLength = 32768;
    private List<JPPFBuffer> list = new ArrayList<JPPFBuffer>();
    private JPPFBuffer currentBuffer = null;
    private int totalSize = 0;
    private boolean hasInitialBuffers = false;
    private int bufferIndex = 0;

    public MultipleBuffersOutputStream() {
    }

    public MultipleBuffersOutputStream(List<JPPFBuffer> initialList) {
        for (JPPFBuffer buf : initialList) {
            this.list.add(new JPPFBuffer(buf.buffer, 0));
        }
        this.hasInitialBuffers = true;
    }

    public MultipleBuffersOutputStream(int defaultLength) throws IllegalArgumentException {
        if (defaultLength <= 0) {
            throw new IllegalArgumentException("the default buffer length must be > 0");
        }
        this.defaultLength = defaultLength;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.currentBuffer == null || this.currentBuffer.remaining() < 1) {
            this.newCurrentBuffer(this.defaultLength);
        }
        this.currentBuffer.buffer[this.currentBuffer.length] = (byte)b;
        ++this.currentBuffer.length;
        ++this.totalSize;
        if (traceEnabled) {
            log.trace("wrote one byte '" + b + "' to " + this);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("the input buffer must not be null");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("b.length=" + b.length + ", off=" + off + ", len=" + len);
        }
        if (this.currentBuffer == null || this.currentBuffer.remaining() < len) {
            this.newCurrentBuffer(Math.max(this.defaultLength, len));
        }
        System.arraycopy(b, off, this.currentBuffer.buffer, this.currentBuffer.length, len);
        this.currentBuffer.length += len;
        this.totalSize += len;
        if (traceEnabled) {
            log.trace("wrote " + len + " bytes to " + this + ", bytes = " + StringUtils.dumpBytes(this.currentBuffer.buffer, this.currentBuffer.length - len, Math.min(100, len)));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("the input buffer must not be null");
        }
        this.write(b, 0, b.length);
    }

    private void newCurrentBuffer(int size) {
        if (traceEnabled) {
            log.trace("creating new buffer with size=" + size + " for " + this);
        }
        if (this.hasInitialBuffers) {
            this.currentBuffer = this.list.get(this.bufferIndex++);
            this.currentBuffer.length = 0;
        } else {
            this.currentBuffer = new JPPFBuffer(new byte[size], 0);
            this.list.add(this.currentBuffer);
        }
    }

    public int size() {
        return this.totalSize;
    }

    public List<JPPFBuffer> toBufferList() {
        return this.list;
    }

    public byte[] toByteArray() {
        if (this.totalSize >= 1 && this.list.get((int)0).length == this.totalSize) {
            return this.list.get((int)0).buffer;
        }
        int pos = 0;
        byte[] tmp = new byte[this.totalSize];
        for (JPPFBuffer buf : this.list) {
            System.arraycopy(buf.buffer, 0, tmp, pos, buf.length);
            pos += buf.length;
        }
        return tmp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("defaultLength=").append(this.defaultLength);
        sb.append(", totalSize=").append(this.totalSize);
        sb.append(", nbBuffers=").append(this.list.size());
        if (this.currentBuffer == null) {
            sb.append(", currentBuffer=null");
        } else {
            sb.append(", currentBuffer.length=").append(this.currentBuffer.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

