/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

public class Range<T extends Comparable<T>> {
    private T lower;
    private T upper;

    public Range(T value) {
        this(value, value);
    }

    public Range(T lower, T upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public boolean isValueInRange(T value) {
        return value.compareTo(this.lower) >= 0 && value.compareTo(this.upper) <= 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lower);
        if (!this.lower.equals(this.upper)) {
            sb.append("-").append(this.upper);
        }
        return sb.toString();
    }

    public T getLower() {
        return this.lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public boolean intersects(Range<T> other) {
        if (other == null) {
            return false;
        }
        return other.isValueInRange(this.lower) || other.isValueInRange(this.upper) || this.includes(other);
    }

    public boolean includes(Range<T> other) {
        if (other == null) {
            return false;
        }
        return other.getLower().compareTo(this.lower) >= 0 && other.getUpper().compareTo(this.upper) <= 0;
    }

    public Range<T> merge(Range<T> other) {
        if (other == null) {
            return new Range<T>(this.getLower(), this.getUpper());
        }
        T minLower = this.lower.compareTo(other.getLower()) <= 0 ? this.lower : other.getLower();
        T maxUpper = this.upper.compareTo(other.getUpper()) >= 0 ? this.upper : other.getUpper();
        return new Range<T>(minLower, maxUpper);
    }

    public Range<T> intersection(Range<T> other) {
        if (other == null || !this.intersects(other)) {
            return null;
        }
        T maxLower = this.lower.compareTo(other.getLower()) >= 0 ? this.lower : other.getLower();
        T minUpper = this.upper.compareTo(other.getUpper()) <= 0 ? this.upper : other.getUpper();
        return new Range<T>(maxLower, minUpper);
    }
}

