/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] writeInt(int value) {
        return SerializationUtils.writeInt(value, new byte[4], 0);
    }

    public static byte[] writeInt(int value, byte[] data, int offset) {
        int pos = offset;
        data[pos++] = (byte)(value >>> 24 & 0xFF);
        data[pos++] = (byte)(value >>> 16 & 0xFF);
        data[pos++] = (byte)(value >>> 8 & 0xFF);
        data[pos++] = (byte)(value >>> 0 & 0xFF);
        return data;
    }

    public static void writeInt(int value, OutputStream os) throws IOException {
        os.write((byte)(value >>> 24 & 0xFF));
        os.write((byte)(value >>> 16 & 0xFF));
        os.write((byte)(value >>> 8 & 0xFF));
        os.write((byte)(value >>> 0 & 0xFF));
    }

    public static void writeInt(WritableByteChannel channel, int value) throws IOException {
        int n;
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(value);
        buf.flip();
        for (int count = 0; count < 4; count += n) {
            n = 0;
            while (n == 0) {
                n = channel.write(buf);
            }
            if (n >= 0) continue;
            throw new ClosedChannelException();
        }
    }

    public static int readInt(ReadableByteChannel channel) throws IOException {
        int n;
        ByteBuffer buf = ByteBuffer.allocate(4);
        for (int count = 0; count < 4; count += n) {
            n = 0;
            while (n == 0) {
                n = channel.read(buf);
            }
            if (n >= 0) continue;
            throw new ClosedChannelException();
        }
        buf.flip();
        return buf.getInt();
    }

    public static int readInt(byte[] data, int offset) {
        int pos = offset;
        int result = SerializationUtils.convertByte(data[pos++]) << 24;
        result += SerializationUtils.convertByte(data[pos++]) << 16;
        result += SerializationUtils.convertByte(data[pos++]) << 8;
        return result += SerializationUtils.convertByte(data[pos++]) << 0;
    }

    public static int readInt(InputStream is) throws IOException {
        int result = SerializationUtils.convertByte(is.read()) << 24;
        result += SerializationUtils.convertByte(is.read()) << 16;
        result += SerializationUtils.convertByte(is.read()) << 8;
        return result += SerializationUtils.convertByte(is.read()) << 0;
    }

    private static int convertByte(int b) {
        return b < 0 ? b + 256 : b;
    }
}

