/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFinder {
    private static Logger log = LoggerFactory.getLogger(ServiceFinder.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public <T> List<T> findProviders(Class<T> providerClass, ClassLoader cl) {
        if (providerClass == null) {
            throw new IllegalArgumentException("Provider class cannot be null");
        }
        if (cl == null) {
            throw new NullPointerException("The specified class loader cannot be null");
        }
        ArrayList list = new ArrayList();
        String name = providerClass.getName();
        List<String> lines = this.findServiceDefinitions("META-INF/services/" + name, cl);
        for (String s : lines) {
            try {
                Class<?> clazz;
                block9: {
                    clazz = null;
                    if (cl instanceof AbstractJPPFClassLoader) {
                        try {
                            clazz = ((AbstractJPPFClassLoader)cl).loadJPPFClass(s);
                        }
                        catch (Exception e) {
                            if (!debugEnabled) break block9;
                            log.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (clazz == null) {
                    clazz = cl.loadClass(s);
                }
                Object t = clazz.newInstance();
                list.add(t);
            }
            catch (Exception e) {
                if (!debugEnabled) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public <T> List<T> findProviders(Class<T> providerClass) {
        return this.findProviders(providerClass, Thread.currentThread().getContextClassLoader());
    }

    private List<URL> resourcesList(String path, ClassLoader cl) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Enumeration<URL> enu = cl.getResources(path);
            while (enu.hasMoreElements()) {
                urls.add(enu.nextElement());
            }
        }
        catch (IOException e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(e.getMessage());
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> findServiceDefinitions(String path, ClassLoader cl) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            List<URL> urls = this.resourcesList(path, cl);
            for (URL url : urls) {
                InputStream is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                try {
                    List<String> fileLines = FileUtils.textFileAsLines(reader);
                    for (String s : fileLines) {
                        int idx = s.indexOf(35);
                        if (idx > 0) {
                            s = s.substring(0, idx);
                        }
                        if ((s = s.trim()).startsWith("#")) continue;
                        lines.add(s);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            log.warn(e.getMessage());
        }
        return lines;
    }

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass, ClassLoader cl) {
        return new ServiceFinder().findProviders(providerClass, cl).iterator();
    }

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass) {
        return new ServiceFinder().findProviders(providerClass).iterator();
    }
}

