/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jppf.utils.HostPort;

public final class StringUtils {
    private static final String[] KEYWORDS = new String[]{"Execution", "Maximum", "Minimum", "Average", "Cumulated"};
    private static final String[] REPLACEMENTS = new String[]{"Exec", "Max", "Min", "Avg", "Cumul"};
    public static final Charset UTF_8 = StringUtils.makeUTF8();
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private StringUtils() {
    }

    public static String padLeft(String source, char padChar, int maxLen) {
        int length;
        StringBuilder sb = new StringBuilder();
        if (source == null) {
            source = "";
        }
        if ((length = source.length()) > maxLen) {
            return source;
        }
        for (int i = 0; i < maxLen - length; ++i) {
            sb.append(padChar);
        }
        sb.append(source);
        return sb.toString();
    }

    public static String padRight(String source, char padChar, int maxLen) {
        String s = source;
        if (s == null) {
            s = "";
        }
        if (s.length() > maxLen) {
            s = s.substring(0, maxLen);
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < maxLen) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String dumpBytes(byte[] bytes, int start, int length) {
        StringBuilder sb = new StringBuilder();
        if (length >= 0) {
            for (int i = start; i < Math.min(bytes.length, start + length); ++i) {
                if (i > start) {
                    sb.append(' ');
                }
                sb.append(StringUtils.toHexString(bytes[i]));
            }
        }
        return sb.toString();
    }

    public static String toHexString(byte b) {
        int n = b < 0 ? b + 256 : b;
        StringBuilder sb = new StringBuilder();
        sb.append(hexDigits[n / 16]);
        sb.append(hexDigits[n % 16]);
        return sb.toString();
    }

    public static byte[] toBytes(String hexString) {
        String[] bytes;
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (String bStr : bytes = hexString.split("\\s")) {
            int n = Byte.parseByte(bStr.substring(0, 1), 16);
            n = 16 * n + Byte.parseByte(bStr.substring(1), 16);
            list.add((byte)n);
        }
        byte[] result = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Byte)list.get(i);
        }
        return result;
    }

    public static String toStringDuration(long elapsed) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.padLeft("" + elapsed / 3600000L, '0', 2)).append(":");
        sb.append(StringUtils.padLeft("" + (elapsed %= 3600000L) / 60000L, '0', 2)).append(":");
        sb.append(StringUtils.padLeft("" + (elapsed %= 60000L) / 1000L, '0', 2)).append(".");
        sb.append(StringUtils.padLeft("" + elapsed % 1000L, '0', 3));
        return sb.toString();
    }

    public static String shortenLabel(String key) {
        for (int i = 0; i < KEYWORDS.length; ++i) {
            if (key.indexOf(KEYWORDS[i]) < 0) continue;
            key = key.replace(KEYWORDS[i], REPLACEMENTS[i]);
        }
        return key;
    }

    public static String getRemoteHost(Channel channel) {
        StringBuilder sb = new StringBuilder();
        if (channel instanceof SocketChannel) {
            if (channel.isOpen()) {
                Socket s = ((SocketChannel)channel).socket();
                sb.append(StringUtils.getRemoteHost((InetSocketAddress)s.getRemoteSocketAddress()));
            } else {
                sb.append("[channel closed]");
            }
        } else {
            sb.append("[JVM-local]");
        }
        return sb.toString();
    }

    public static String getRemoteHost(SocketAddress address) {
        StringBuilder sb = new StringBuilder();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress add = (InetSocketAddress)address;
            sb.append(add.getHostName()).append(":").append(add.getPort());
        } else {
            sb.append("socket address type not handled: " + address);
        }
        return sb.toString();
    }

    public static <T> String arrayToString(T[] array) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            sb.append("null");
        } else {
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(array[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public static int[] parseIntValues(String s) {
        String[] strPorts = s.split("\\s");
        ArrayList<Integer> portList = new ArrayList<Integer>();
        for (String sp : strPorts) {
            try {
                int n = Integer.valueOf(sp.trim());
                portList.add(n);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        int[] ports = new int[portList.size()];
        for (int i = 0; i < portList.size(); ++i) {
            ports[i] = (Integer)portList.get(i);
        }
        return ports;
    }

    public static String buildString(int[] ports) {
        if (ports == null || ports.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(ports[i]);
        }
        return sb.toString();
    }

    public static HostPort parseHostPort(String s) {
        String[] comps = s.split(":");
        int port = -1;
        try {
            port = Integer.valueOf(comps[1].trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new HostPort(comps[0], port);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String buildString(Object ... args) {
        if (args == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : args) {
            sb.append(o);
        }
        return sb.toString();
    }

    public static boolean startsWithOneOf(String source, boolean ignoreCase, String ... values) {
        if (source == null || values == null) {
            return false;
        }
        String s = ignoreCase ? source.toLowerCase() : source;
        for (String val : values) {
            String s2;
            if (val == null) continue;
            String string = s2 = ignoreCase ? val.toLowerCase() : val;
            if (!s.startsWith(s2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(String source, boolean ignoreCase, String ... values) {
        if (source == null || values == null) {
            return false;
        }
        String s = ignoreCase ? source.toLowerCase() : source;
        for (String val : values) {
            String s2;
            if (val == null) continue;
            String string = s2 = ignoreCase ? val.toLowerCase() : val;
            if (!s.equals(s2)) continue;
            return true;
        }
        return false;
    }

    public static int[] toIntArray(InetAddress addr) {
        try {
            byte[] bytes = addr.getAddress();
            String ip = addr.getHostAddress();
            int[] result = null;
            if (addr instanceof Inet6Address) {
                result = new int[8];
                String[] comp = ip.split(":");
                for (int i = 0; i < comp.length; ++i) {
                    result[i] = Integer.decode("0x" + comp[i].toLowerCase());
                }
            } else {
                result = new int[8];
                String[] comp = ip.split("\\.");
                for (int i = 0; i < comp.length; ++i) {
                    result[i] = Integer.valueOf(comp[i]);
                }
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] toIntArray(String source, Pattern separatorPattern) {
        try {
            String[] vals = separatorPattern.split(source);
            int[] result = new int[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                result[i] = Integer.valueOf(vals[i]);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Charset makeUTF8() {
        Charset utf8 = null;
        try {
            utf8 = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            return null;
        }
        return utf8;
    }
}

