/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TypedProperties
extends Properties {
    public TypedProperties() {
    }

    public TypedProperties(Map<Object, Object> map) {
        if (map != null) {
            Set<Map.Entry<Object, Object>> entries = map.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getString(String key, String defValue) {
        String val = this.getProperty(key);
        if (val == null) {
            return defValue;
        }
        return val;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defValue) {
        int intVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                intVal = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return intVal;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defValue) {
        long longVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                longVal = Long.parseLong(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return longVal;
    }

    public float getFloat(String key, float defValue) {
        float floatVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                floatVal = Float.parseFloat(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return floatVal;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public double getDouble(String key, double defValue) {
        double doubleVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                doubleVal = Double.parseDouble(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return doubleVal;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public boolean getBoolean(String key, boolean defValue) {
        boolean booleanVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            booleanVal = Boolean.valueOf(val.trim());
        }
        return booleanVal;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public TypedProperties getProperties(String key) {
        return this.getProperties(key, null);
    }

    public TypedProperties getProperties(String key, TypedProperties def) {
        String path = this.getString(key);
        File file = new File(path);
        if (!file.exists()) {
            return def;
        }
        TypedProperties res = new TypedProperties();
        try {
            res.load(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            return def;
        }
        return res;
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Object, Object>> entries = this.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public void loadString(String source) throws IOException {
        if (source == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(source.getBytes());
        this.load(bais);
        bais.close();
    }
}

