/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jppf.utils.TypedProperties;

public final class VersionUtils {
    private static int buildNumber = -1;
    private static String ip = VersionUtils.getLocalIpAddress();

    private VersionUtils() {
    }

    public static int getBuildNumber() {
        if (buildNumber < 0) {
            try {
                InputStream is = VersionUtils.class.getClassLoader().getResourceAsStream("build.number");
                TypedProperties props = new TypedProperties();
                props.load(is);
                buildNumber = props.getInt("build.number");
            }
            catch (Exception ignored) {
                buildNumber = 0;
            }
        }
        return buildNumber;
    }

    public static void setBuildNumber(int buildNumber) {
        VersionUtils.buildNumber = buildNumber;
    }

    public static String getLocalIpAddress() {
        if (ip != null) {
            return ip;
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            return ip.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }
}

