/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;

public class SocketChannelClient
implements SocketWrapper {
    private static Log log = LogFactory.getLog(SocketChannelClient.class);
    private SocketChannel channel = null;
    private String host = null;
    private int port = -1;
    private ObjectSerializer serializer = null;
    private boolean opened = false;
    private boolean blocking = false;

    public SocketChannelClient(boolean blocking) throws IOException {
        this.blocking = blocking;
    }

    public SocketChannelClient(String host, int port, boolean blocking) throws IOException {
        this(blocking);
        this.host = host;
        this.port = port;
    }

    public void send(Object o) throws Exception {
        JPPFBuffer buf = this.getSerializer().serialize(o);
        this.sendBytes(buf);
    }

    public void sendBytes(JPPFBuffer buf) throws Exception {
        int length = buf.getLength();
        this.writeInt(length);
        this.write(buf.getBuffer(), 0, length);
    }

    public void write(byte[] data, int offset, int len) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, len);
        int count = 0;
        while (count < len) {
            count += this.channel.write(buffer);
        }
    }

    public void writeInt(int n) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(n);
        buffer.flip();
        int count = 0;
        while (count < 4) {
            count += this.channel.write(buffer);
        }
    }

    public void flush() throws IOException {
    }

    public Object receive() throws Exception {
        return this.receive(0);
    }

    public Object receive(int timeout) throws Exception {
        Object o = null;
        try {
            if (timeout > 0) {
                this.channel.socket().setSoTimeout(timeout);
            }
            JPPFBuffer buf = this.receiveBytes(timeout);
            o = this.getSerializer().deserialize(buf);
        }
        finally {
            if (timeout > 0) {
                this.channel.socket().setSoTimeout(0);
            }
        }
        return o;
    }

    public JPPFBuffer receiveBytes(int timeout) throws Exception {
        int length = this.readInt();
        byte[] data = new byte[length];
        this.read(data, 0, length);
        return new JPPFBuffer(data, length);
    }

    public int read(byte[] data, int offset, int len) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, len);
        int count = 0;
        while (count < len) {
            count += this.channel.read(byteBuffer);
        }
        return count;
    }

    public int readInt() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(4);
        int count = 0;
        while (count < 4) {
            count += this.channel.read(buf);
        }
        buf.flip();
        return buf.getInt();
    }

    public void open() throws ConnectException, IOException {
        this.channel = SocketChannel.open();
        this.channel.socket().setReceiveBufferSize(65536);
        this.channel.socket().setSendBufferSize(65536);
        this.channel.configureBlocking(this.blocking);
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        this.channel.connect(address);
        if (!this.channel.isBlocking()) {
            while (!this.channel.finishConnect()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.opened = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getReceiveBufferSize() = " + this.channel.socket().getReceiveBufferSize()));
        }
    }

    public void close() throws ConnectException, IOException {
        if (this.opened) {
            this.channel.close();
            this.opened = false;
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public ObjectSerializer getSerializer() {
        if (this.serializer == null) {
            String name = "org.jppf.utils.ObjectSerializerImpl";
            try {
                this.serializer = (ObjectSerializer)Class.forName(name).newInstance();
            }
            catch (InstantiationException e) {
                log.fatal((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.serializer;
    }

    public void setSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Socket getSocket() {
        return this.channel.socket();
    }

    public void setSocket(Socket socket) {
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public int skip(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("number of bytes to skip must be >= 0");
        }
        if (n == 0) {
            return 0;
        }
        ByteBuffer buf = ByteBuffer.allocate(n);
        while (buf.hasRemaining()) {
            int r = this.channel.read(buf);
            if (r == 0 && this.blocking || r < 0) break;
        }
        return buf.position();
    }

    public void write(byte[] data) throws Exception {
        this.write(data, 0, data.length);
    }
}

