/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.doc;

import java.io.File;
import java.io.FileFilter;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.jppf.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocGenerator {
    public static final String TEMPLATE_START = "$template{";
    public static final String TEMPLATE_END = "}$";
    public static final String CONTENT_START = "$CONTENT[";
    public static final String CONTENT_END = "]CONTENT$";
    public static final String EQUALS = "=";
    public static final String QUOTE = "\"";
    public static final String COMMENT = "#";
    public static final String PARAM_START = "${";
    public static final String PARAM_END = "}";

    public void generatePage(String source, String target, String templateFolder) throws Exception {
        System.out.println("Processing source file " + source);
        String s = FileUtils.readTextFile((String)source);
        s = this.processTemplates(new HashMap<String, String>(), s, templateFolder);
        FileUtils.writeTextFile((String)target, (String)s);
    }

    private String processTemplates(Map<String, String> parameterMap, String content, String templateFolder) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean end = false;
        int pos = 0;
        while (!end && pos >= 0 && pos < content.length()) {
            int index = content.indexOf(TEMPLATE_START, pos);
            if (index < 0) {
                if (pos >= content.length()) break;
                sb.append(content.substring(pos));
                break;
            }
            sb.append(content.substring(pos, index));
            pos = index;
            index = content.indexOf(TEMPLATE_END, pos + TEMPLATE_START.length());
            if (index < 0) continue;
            String templateCall = content.substring(pos, index + TEMPLATE_END.length());
            sb.append(this.processTemplateCall(templateCall, parameterMap, templateFolder));
            pos = index + TEMPLATE_END.length();
        }
        return this.processParameters(parameterMap, sb.toString());
    }

    private String processTemplateCall(String templateCall, Map<String, String> callerMap, String templateFolder) throws Exception {
        String templateFile;
        int pos;
        int index = pos = TEMPLATE_START.length();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        while (index > 0) {
            index = templateCall.indexOf(EQUALS, pos);
            if (index >= 0) {
                String paramName = templateCall.substring(pos, index).trim();
                String paramValue = "";
                index = templateCall.indexOf(QUOTE, pos);
                if (index < 0) {
                    throw new Exception("Missing opening quote for parameter '" + paramName + "'");
                }
                pos = index + QUOTE.length();
                String sub = templateCall.substring(pos);
                if (sub.startsWith(CONTENT_START)) {
                    index = templateCall.indexOf("]CONTENT$\"", pos += CONTENT_START.length());
                    if (index < 0) {
                        throw new Exception("Missing closing content string for parameter '" + paramName + "' in template call: '" + templateCall + "'");
                    }
                    paramValue = templateCall.substring(pos, index).trim();
                    paramValue = this.processParameters(callerMap, paramValue);
                    pos = index + "]CONTENT$\"".length();
                } else {
                    pos = index + QUOTE.length();
                    if ((index = templateCall.indexOf(QUOTE, pos)) < 0) {
                        throw new Exception("Missing closing quote for parameter '" + paramName + "'");
                    }
                    paramValue = templateCall.substring(pos, index).trim();
                    pos = index + QUOTE.length();
                }
                parameterMap.put(paramName, paramValue);
            }
            if (!templateCall.substring(pos).startsWith(TEMPLATE_END)) continue;
            pos += TEMPLATE_END.length();
            break;
        }
        if (!templateFolder.endsWith("/")) {
            templateFolder = String.valueOf(templateFolder) + "/";
        }
        if (!new File(templateFile = String.valueOf(templateFolder) + (String)parameterMap.get("name") + ".html").exists()) {
            throw new Exception("Could not find template file " + templateFile);
        }
        String content = FileUtils.readTextFile((String)templateFile);
        content = this.processTemplates(parameterMap, content, templateFolder);
        content = this.processParameters(parameterMap, content);
        return content;
    }

    private String processParameters(Map<String, String> parameterMap, String content) throws Exception {
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        StringBuilder sb = new StringBuilder();
        String s = "";
        while (s != null) {
            s = reader.readLine();
            if (s == null) break;
            String s2 = s.trim();
            if ("".equals(s2) || s2.startsWith(COMMENT)) continue;
            sb.append(s).append("\n");
        }
        reader.close();
        String template = sb.toString();
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String param = PARAM_START + entry.getKey() + PARAM_END;
            template = template.replace(param, entry.getValue());
        }
        return template;
    }

    public static void main(String ... args) {
        try {
            File templateDir;
            File targetDir;
            File sourceDir;
            if (args.length < 3) {
                HtmlDocGenerator.showUsageAndExit("Missing parameter(s).\n");
            }
            if (args.length > 3) {
                HtmlDocGenerator.showUsageAndExit("Too many parameter(s).\n");
            }
            if (!(sourceDir = new File(args[0])).exists() || !sourceDir.isDirectory()) {
                HtmlDocGenerator.showUsageAndExit("Source location must be an existing folder");
            }
            if (!(targetDir = new File(args[1])).exists() || !targetDir.isDirectory()) {
                HtmlDocGenerator.showUsageAndExit("Target location must be an existing folder");
            }
            if (!(templateDir = new File(args[2])).exists() || !templateDir.isDirectory()) {
                HtmlDocGenerator.showUsageAndExit("Templates location must be an existing folder");
            }
            HtmlDocGenerator docGen = new HtmlDocGenerator();
            File[] fileArray = sourceDir.listFiles(new JPPFFileFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String target = targetDir.getPath();
                if (!target.endsWith("/") && !target.endsWith("\\")) {
                    target = String.valueOf(target) + "/";
                }
                target = String.valueOf(target) + file.getName();
                docGen.generatePage(file.getPath(), target, templateDir.getPath());
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void showUsageAndExit(String msg) {
        System.err.println(msg);
        System.err.println("HtmlDocGenerator usage: java " + HtmlDocGenerator.class.getName() + " sourceDir" + " targetDir" + " templatesDir");
        System.err.println();
        System.err.println("Where:");
        System.err.println("- sourceDir is the location of the folder with the documents sources (those that use templates)");
        System.err.println("- targetDir is the location of the folder where the actual HTML documents are created");
        System.err.println("- templatesDir is the location of the root folder where the templates are");
        System.err.println();
        System.err.println("This tool only handles html documents, thus any other file has to be already in the right location,");
        System.err.println("including stylesheets, image files and others.");
        System.exit(0);
    }

    public static class JPPFFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return false;
            }
            String s = pathname.getPath();
            int idx = s.lastIndexOf(".");
            if (idx < 0) {
                return false;
            }
            return ".html".equals(s = s.substring(idx).toLowerCase()) || ".htm".equals(s) || ".php".equals(s);
        }
    }
}

