/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jppf.io.InputSource;

public class ByteBufferInputSource
implements InputSource {
    private ByteBuffer data = null;

    public ByteBufferInputSource(byte[] data, int offset, int len) {
        this(ByteBuffer.wrap(data, offset, len));
    }

    public ByteBufferInputSource(ByteBuffer data) {
        this.data = data;
    }

    public int read(byte[] buffer, int offset, int len) throws Exception {
        int pos = this.data.position();
        this.data.get(buffer, offset, len);
        return this.data.position() - pos;
    }

    public int read(ByteBuffer buffer) throws Exception {
        int pos = buffer.position();
        if (this.data.remaining() > buffer.remaining()) {
            int limit = this.data.limit();
            this.data.limit(this.data.position() + buffer.remaining());
            buffer.put(this.data);
            this.data.limit(limit);
        } else {
            buffer.put(this.data);
        }
        return buffer.position() - pos;
    }

    public int readInt() throws Exception {
        return this.data.getInt();
    }

    public int skip(int n) throws Exception {
        if (!this.data.hasRemaining()) {
            return -1;
        }
        int count = Math.min(n, this.data.remaining());
        this.data.position(count);
        return count;
    }

    public void close() throws IOException {
    }
}

