/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jppf.io.AbstractDataLocation;
import org.jppf.io.ByteBufferInputStream;
import org.jppf.io.ByteBufferOutputStream;
import org.jppf.io.DataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.OutputDestination;

public class ByteBufferLocation
extends AbstractDataLocation {
    private ByteBuffer buffer = null;

    public ByteBufferLocation(int capacity) {
        this(new byte[capacity], 0, capacity);
    }

    public ByteBufferLocation(byte[] data, int offset, int len) {
        this(ByteBuffer.wrap(data, offset, len));
    }

    public ByteBufferLocation(ByteBuffer buffer) {
        this.buffer = buffer;
        this.size = buffer.limit();
    }

    public int transferFrom(InputSource source, boolean blocking) throws Exception {
        if (!this.transferring) {
            this.transferring = true;
            this.buffer.rewind();
        }
        if (!blocking) {
            int n = source.read(this.buffer);
            if (n < 0 || !this.buffer.hasRemaining()) {
                this.transferring = false;
            }
            return n;
        }
        int count = 0;
        while (count < this.size) {
            int n = source.read(this.buffer);
            if (n < 0) {
                this.transferring = false;
                return -1;
            }
            count += n;
        }
        this.transferring = false;
        return count;
    }

    public int transferTo(OutputDestination dest, boolean blocking) throws Exception {
        if (!this.transferring) {
            this.transferring = true;
            this.buffer.rewind();
        }
        if (!blocking) {
            int n = dest.write(this.buffer);
            if (n < 0 || !this.buffer.hasRemaining()) {
                this.transferring = false;
            }
            return n;
        }
        int count = 0;
        while (count < this.size) {
            int n = dest.write(this.buffer);
            if (n < 0) {
                this.transferring = false;
                return -1;
            }
            count += n;
        }
        this.transferring = false;
        return count;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public InputStream getInputStream() throws Exception {
        this.buffer.rewind();
        return new ByteBufferInputStream(this.buffer, false);
    }

    public OutputStream getOutputStream() throws Exception {
        return new ByteBufferOutputStream(this.buffer);
    }

    public DataLocation copy() {
        byte[] array = this.buffer.array();
        return new ByteBufferLocation(array, 0, array.length);
    }
}

