/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jppf.io.OutputDestination;

public class ByteBufferOutputDestination
implements OutputDestination {
    private ByteBuffer data = null;

    public ByteBufferOutputDestination(int size) {
        this(ByteBuffer.allocate(size));
    }

    public ByteBufferOutputDestination(byte[] buffer, int offset, int len) {
        this(ByteBuffer.wrap(buffer, offset, len));
    }

    public ByteBufferOutputDestination(ByteBuffer buffer) {
        this.data = buffer;
    }

    public int write(byte[] buffer, int offset, int len) throws Exception {
        int pos = this.data.position();
        this.data.put(buffer, offset, len);
        return this.data.position() - pos;
    }

    public int write(ByteBuffer buffer) throws Exception {
        int pos = this.data.position();
        if (buffer.remaining() > this.data.remaining()) {
            int limit = buffer.limit();
            buffer.limit(buffer.position() + this.data.remaining());
            this.data.put(buffer);
            buffer.limit(limit);
        } else {
            this.data.put(buffer);
        }
        return this.data.position() - pos;
    }

    public void writeInt(int value) throws Exception {
        this.data.putInt(value);
    }

    public void close() throws IOException {
    }
}

