/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jppf.io.InputSource;
import org.jppf.utils.SerializationUtils;

public class ChannelInputSource
implements InputSource {
    protected ReadableByteChannel channel = null;

    public ChannelInputSource(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public int read(byte[] data, int offset, int len) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(data, offset, len);
        return this.read(buffer);
    }

    public int read(ByteBuffer data) throws Exception {
        int n = this.channel.read(data);
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int readInt() throws Exception {
        return SerializationUtils.readInt((ReadableByteChannel)this.channel);
    }

    public int skip(int n) throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(n);
        this.read(buf);
        return buf.position();
    }

    public void close() throws IOException {
    }
}

